/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.ExpressionBasedStringQuery;
import org.springframework.data.jpa.repository.query.JpaEntityMetadata;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.jpa.repository.query.SpelExpressionStringQueryParameterBinder;
import org.springframework.data.jpa.repository.query.StringQuery;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

abstract class AbstractStringBasedJpaQuery
extends AbstractJpaQuery {
    private final StringQuery query;
    private final StringQuery countQuery;
    private final EvaluationContextProvider evaluationContextProvider;
    private final SpelExpressionParser parser;

    public AbstractStringBasedJpaQuery(JpaQueryMethod method, EntityManager em, String queryString, EvaluationContextProvider evaluationContextProvider, SpelExpressionParser parser) {
        super(method, em);
        Assert.hasText(queryString, "Query string must not be null or empty!");
        Assert.notNull(evaluationContextProvider, "ExpressionEvaluationContextProvider must not be null!");
        Assert.notNull(parser, "Parser must not be null or empty!");
        this.evaluationContextProvider = evaluationContextProvider;
        this.query = new ExpressionBasedStringQuery(queryString, (JpaEntityMetadata<?>)method.getEntityInformation(), parser);
        this.countQuery = new StringQuery(method.getCountQuery() != null ? method.getCountQuery() : QueryUtils.createCountQueryFor(this.query.getQueryString(), method.getCountQueryProjection()));
        this.parser = parser;
    }

    @Override
    public Query doCreateQuery(Object[] values2) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.getQueryMethod().getParameters(), values2);
        String sortedQueryString = QueryUtils.applySorting(this.query.getQueryString(), accessor.getSort(), this.query.getAlias());
        ResultProcessor processor = this.getQueryMethod().getResultProcessor().withDynamicProjection(accessor);
        Query query = this.createJpaQuery(sortedQueryString, processor.getReturnedType());
        return this.createBinder(values2).bindAndPrepare(query);
    }

    @Override
    protected ParameterBinder createBinder(Object[] values2) {
        return new SpelExpressionStringQueryParameterBinder(this.getQueryMethod().getParameters(), values2, this.query, this.evaluationContextProvider, this.parser);
    }

    @Override
    protected Query doCreateCountQuery(Object[] values2) {
        String queryString = this.countQuery.getQueryString();
        EntityManager em = this.getEntityManager();
        TypedQuery<Long> query = this.getQueryMethod().isNativeQuery() ? em.createNativeQuery(queryString) : em.createQuery(queryString, Long.class);
        return this.createBinder(values2).bind(query);
    }

    public StringQuery getQuery() {
        return this.query;
    }

    public StringQuery getCountQuery() {
        return this.countQuery;
    }

    protected Query createJpaQuery(String queryString, ReturnedType returnedType) {
        EntityManager em = this.getEntityManager();
        if (this.query.hasConstructorExpression() || this.query.isDefaultProjection()) {
            return em.createQuery(queryString);
        }
        Class<?> typeToRead = this.getTypeToRead(returnedType);
        return typeToRead == null ? em.createQuery(queryString) : em.createQuery(queryString, typeToRead);
    }
}

