/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import java.io.Serializable;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.data.jpa.projection.CollectionAwareProjectionFactory;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.jpa.repository.query.JpaQueryLookupStrategy;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.support.CrudMethodMetadataPostProcessor;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.JpaEntityInformationSupport;
import org.springframework.data.jpa.repository.support.QueryDslJpaRepository;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.data.jpa.util.JpaMetamodel;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.querydsl.QueryDslPredicateExecutor;
import org.springframework.data.querydsl.QueryDslUtils;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.QueryCreationListener;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.util.Assert;

public class JpaRepositoryFactory
extends RepositoryFactorySupport {
    private final EntityManager entityManager;
    private final QueryExtractor extractor;
    private final CrudMethodMetadataPostProcessor crudMethodMetadataPostProcessor;
    private EscapeCharacter escapeCharacter = EscapeCharacter.DEFAULT;

    public JpaRepositoryFactory(EntityManager entityManager) {
        Assert.notNull(entityManager, "EntityManager must not be null!");
        this.entityManager = entityManager;
        this.extractor = PersistenceProvider.fromEntityManager(entityManager);
        this.crudMethodMetadataPostProcessor = new CrudMethodMetadataPostProcessor();
        this.addRepositoryProxyPostProcessor(this.crudMethodMetadataPostProcessor);
        if (this.extractor.equals(PersistenceProvider.ECLIPSELINK)) {
            this.addQueryCreationListener(new EclipseLinkProjectionQueryCreationListener(entityManager));
        }
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        super.setBeanClassLoader(classLoader);
        this.crudMethodMetadataPostProcessor.setBeanClassLoader(classLoader);
    }

    public void setEscapeCharacter(EscapeCharacter escapeCharacter) {
        this.escapeCharacter = escapeCharacter;
    }

    @Override
    protected Object getTargetRepository(RepositoryInformation information) {
        SimpleJpaRepository<?, ?> repository = this.getTargetRepository(information, this.entityManager);
        repository.setRepositoryMethodMetadata(this.crudMethodMetadataPostProcessor.getCrudMethodMetadata());
        repository.setEscapeCharacter(this.escapeCharacter);
        return repository;
    }

    protected <T, ID extends Serializable> SimpleJpaRepository<?, ?> getTargetRepository(RepositoryInformation information, EntityManager entityManager) {
        EntityInformation entityInformation = this.getEntityInformation((Class)information.getDomainType());
        return (SimpleJpaRepository)this.getTargetRepositoryViaReflection(information, entityInformation, entityManager);
    }

    @Override
    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        if (this.isQueryDslExecutor(metadata.getRepositoryInterface())) {
            return QueryDslJpaRepository.class;
        }
        return SimpleJpaRepository.class;
    }

    @Override
    protected ProjectionFactory getProjectionFactory(ClassLoader classLoader, BeanFactory beanFactory) {
        CollectionAwareProjectionFactory factory = new CollectionAwareProjectionFactory();
        factory.setBeanClassLoader(classLoader);
        factory.setBeanFactory(beanFactory);
        return factory;
    }

    private boolean isQueryDslExecutor(Class<?> repositoryInterface) {
        return QueryDslUtils.QUERY_DSL_PRESENT && QueryDslPredicateExecutor.class.isAssignableFrom(repositoryInterface);
    }

    @Override
    protected QueryLookupStrategy getQueryLookupStrategy(QueryLookupStrategy.Key key, EvaluationContextProvider evaluationContextProvider) {
        return JpaQueryLookupStrategy.create(this.entityManager, key, this.extractor, evaluationContextProvider, this.escapeCharacter);
    }

    public <T, ID extends Serializable> JpaEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return JpaEntityInformationSupport.getEntityInformation(domainClass, this.entityManager);
    }

    private static class EclipseLinkProjectionQueryCreationListener
    implements QueryCreationListener<AbstractJpaQuery> {
        private static final Logger log = LoggerFactory.getLogger(EclipseLinkProjectionQueryCreationListener.class);
        private static final String ECLIPSELINK_PROJECTIONS = "Usage of Spring Data projections detected on persistence provider EclipseLink. Make sure the following query methods declare result columns in exactly the order the accessors are declared in the projecting interface or the order of parameters for DTOs:";
        private final JpaMetamodel metamodel;
        private boolean warningLogged = false;

        public EclipseLinkProjectionQueryCreationListener(EntityManager em) {
            Assert.notNull(em, "EntityManager must not be null!");
            this.metamodel = new JpaMetamodel(em.getMetamodel());
        }

        @Override
        public void onCreation(AbstractJpaQuery query) {
            JpaQueryMethod queryMethod = query.getQueryMethod();
            ReturnedType type = queryMethod.getResultProcessor().getReturnedType();
            if (type.isProjecting() && !this.metamodel.isJpaManaged(type.getReturnedType())) {
                if (!this.warningLogged) {
                    log.info(ECLIPSELINK_PROJECTIONS);
                    this.warningLogged = true;
                }
                log.info(" - {}", (Object)queryMethod);
            }
        }
    }
}

