/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.projection;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.projection.DefaultProjectionInformation;
import org.springframework.data.projection.ProjectionInformation;
import org.springframework.data.projection.ProxyProjectionFactory;
import org.springframework.data.projection.SpelEvaluatingMethodInterceptor;
import org.springframework.data.util.AnnotationDetectionMethodCallback;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.ReflectionUtils;

public class SpelAwareProxyProjectionFactory
extends ProxyProjectionFactory
implements BeanFactoryAware {
    private final Map<Class<?>, Boolean> typeCache = new ConcurrentHashMap();
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private BeanFactory beanFactory;

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Override
    protected MethodInterceptor postProcessAccessorInterceptor(MethodInterceptor interceptor, Object source, Class<?> projectionType) {
        if (!this.typeCache.containsKey(projectionType)) {
            AnnotationDetectionMethodCallback<Value> callback = new AnnotationDetectionMethodCallback<Value>(Value.class);
            ReflectionUtils.doWithMethods(projectionType, callback);
            this.typeCache.put(projectionType, callback.hasFoundAnnotation());
        }
        return this.typeCache.get(projectionType) != false ? new SpelEvaluatingMethodInterceptor(interceptor, source, this.beanFactory, this.parser, projectionType) : interceptor;
    }

    @Override
    public ProjectionInformation getProjectionInformation(Class<?> projectionType) {
        return new SpelAwareProjectionInformation(projectionType);
    }

    protected static class SpelAwareProjectionInformation
    extends DefaultProjectionInformation {
        protected SpelAwareProjectionInformation(Class<?> projectionType) {
            super(projectionType);
        }

        @Override
        protected boolean isInputProperty(PropertyDescriptor descriptor) {
            if (!super.isInputProperty(descriptor)) {
                return false;
            }
            Method readMethod = descriptor.getReadMethod();
            if (readMethod == null) {
                return false;
            }
            return AnnotationUtils.findAnnotation(readMethod, Value.class) == null;
        }
    }
}

