/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.data.repository.config.RepositoryConfigurationExtension;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.util.Assert;

public abstract class RepositoryConfigurationUtils {
    private RepositoryConfigurationUtils() {
    }

    public static void exposeRegistration(RepositoryConfigurationExtension extension, BeanDefinitionRegistry registry, RepositoryConfigurationSource configurationSource) {
        Assert.notNull(extension, "RepositoryConfigurationExtension must not be null!");
        Assert.notNull(registry, "BeanDefinitionRegistry must not be null!");
        Assert.notNull(configurationSource, "RepositoryConfigurationSource must not be null!");
        Class<?> extensionType = extension.getClass();
        String beanName = extensionType.getName().concat("#").concat("0");
        if (registry.containsBeanDefinition(beanName)) {
            return;
        }
        RootBeanDefinition definition = new RootBeanDefinition(extensionType);
        definition.setSource(configurationSource.getSource());
        definition.setRole(2);
        definition.setLazyInit(true);
        registry.registerBeanDefinition(beanName, definition);
    }
}

