/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SqlOutParameter;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.jdbc.core.SqlReturnResultSet;
import org.springframework.jdbc.core.metadata.CallMetaDataProvider;
import org.springframework.jdbc.core.metadata.CallMetaDataProviderFactory;
import org.springframework.jdbc.core.metadata.CallParameterMetaData;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.StringUtils;

public class CallMetaDataContext {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String procedureName;
    private String catalogName;
    private String schemaName;
    private List<SqlParameter> callParameters = new ArrayList<SqlParameter>();
    private String actualFunctionReturnName;
    private Set<String> limitedInParameterNames = new HashSet<String>();
    private List<String> outParameterNames = new ArrayList<String>();
    private boolean function = false;
    private boolean returnValueRequired = false;
    private boolean accessCallParameterMetaData = true;
    private boolean namedBinding;
    private CallMetaDataProvider metaDataProvider;

    public void setFunctionReturnName(String functionReturnName) {
        this.actualFunctionReturnName = functionReturnName;
    }

    public String getFunctionReturnName() {
        return this.actualFunctionReturnName != null ? this.actualFunctionReturnName : "return";
    }

    public void setLimitedInParameterNames(Set<String> limitedInParameterNames) {
        this.limitedInParameterNames = limitedInParameterNames;
    }

    public Set<String> getLimitedInParameterNames() {
        return this.limitedInParameterNames;
    }

    public void setOutParameterNames(List<String> outParameterNames) {
        this.outParameterNames = outParameterNames;
    }

    public List<String> getOutParameterNames() {
        return this.outParameterNames;
    }

    public void setProcedureName(String procedureName) {
        this.procedureName = procedureName;
    }

    public String getProcedureName() {
        return this.procedureName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setFunction(boolean function) {
        this.function = function;
    }

    public boolean isFunction() {
        return this.function;
    }

    public void setReturnValueRequired(boolean returnValueRequired) {
        this.returnValueRequired = returnValueRequired;
    }

    public boolean isReturnValueRequired() {
        return this.returnValueRequired;
    }

    public void setAccessCallParameterMetaData(boolean accessCallParameterMetaData) {
        this.accessCallParameterMetaData = accessCallParameterMetaData;
    }

    public boolean isAccessCallParameterMetaData() {
        return this.accessCallParameterMetaData;
    }

    public void setNamedBinding(boolean namedBinding) {
        this.namedBinding = namedBinding;
    }

    public boolean isNamedBinding() {
        return this.namedBinding;
    }

    public void initializeMetaData(DataSource dataSource) {
        this.metaDataProvider = CallMetaDataProviderFactory.createMetaDataProvider(dataSource, this);
    }

    public SqlParameter createReturnResultSetParameter(String parameterName, RowMapper<?> rowMapper) {
        if (this.metaDataProvider.isReturnResultSetSupported()) {
            return new SqlReturnResultSet(parameterName, rowMapper);
        }
        if (this.metaDataProvider.isRefCursorSupported()) {
            return new SqlOutParameter(parameterName, this.metaDataProvider.getRefCursorSqlType(), rowMapper);
        }
        throw new InvalidDataAccessApiUsageException("Return of a ResultSet from a stored procedure is not supported");
    }

    public String getScalarOutParameterName() {
        if (this.isFunction()) {
            return this.getFunctionReturnName();
        }
        if (this.outParameterNames.size() > 1) {
            this.logger.warn("Accessing single output value when procedure has more than one output parameter");
        }
        return !this.outParameterNames.isEmpty() ? this.outParameterNames.get(0) : null;
    }

    public List<SqlParameter> getCallParameters() {
        return this.callParameters;
    }

    public void processParameters(List<SqlParameter> parameters) {
        this.callParameters = this.reconcileParameters(parameters);
    }

    protected List<SqlParameter> reconcileParameters(List<SqlParameter> parameters) {
        ArrayList<SqlParameter> declaredReturnParams = new ArrayList<SqlParameter>();
        LinkedHashMap<String, SqlParameter> declaredParams = new LinkedHashMap<String, SqlParameter>();
        boolean returnDeclared = false;
        ArrayList<String> outParamNames = new ArrayList<String>();
        ArrayList<String> metaDataParamNames = new ArrayList<String>();
        for (CallParameterMetaData meta : this.metaDataProvider.getCallParameterMetaData()) {
            if (meta.isReturnParameter()) continue;
            metaDataParamNames.add(meta.getParameterName().toLowerCase());
        }
        for (SqlParameter param : parameters) {
            if (param.isResultsParameter()) {
                declaredReturnParams.add(param);
                continue;
            }
            String paramName = param.getName();
            if (paramName == null) {
                throw new IllegalArgumentException("Anonymous parameters not supported for calls - please specify a name for the parameter of SQL type " + param.getSqlType());
            }
            String paramNameToMatch = this.metaDataProvider.parameterNameToUse(paramName).toLowerCase();
            declaredParams.put(paramNameToMatch, param);
            if (!(param instanceof SqlOutParameter)) continue;
            outParamNames.add(paramName);
            if (!this.isFunction() || metaDataParamNames.contains(paramNameToMatch) || returnDeclared) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Using declared out parameter '" + paramName + "' for function return value");
            }
            this.setFunctionReturnName(paramName);
            returnDeclared = true;
        }
        this.setOutParameterNames(outParamNames);
        ArrayList<SqlParameter> workParams = new ArrayList<SqlParameter>();
        workParams.addAll(declaredReturnParams);
        if (!this.metaDataProvider.isProcedureColumnMetaDataUsed()) {
            workParams.addAll(declaredParams.values());
            return workParams;
        }
        HashMap<String, String> limitedInParamNamesMap = new HashMap<String, String>(this.limitedInParameterNames.size());
        for (String limitedParamName : this.limitedInParameterNames) {
            limitedInParamNamesMap.put(this.metaDataProvider.parameterNameToUse(limitedParamName).toLowerCase(), limitedParamName);
        }
        for (CallParameterMetaData meta : this.metaDataProvider.getCallParameterMetaData()) {
            String paramNameToCheck = null;
            if (meta.getParameterName() != null) {
                paramNameToCheck = this.metaDataProvider.parameterNameToUse(meta.getParameterName()).toLowerCase();
            }
            String paramNameToUse = this.metaDataProvider.parameterNameToUse(meta.getParameterName());
            if (declaredParams.containsKey(paramNameToCheck) || meta.isReturnParameter() && returnDeclared) {
                SqlParameter param;
                if (meta.isReturnParameter()) {
                    param = (SqlParameter)declaredParams.get(this.getFunctionReturnName());
                    if (param == null && !this.getOutParameterNames().isEmpty()) {
                        param = (SqlParameter)declaredParams.get(this.getOutParameterNames().get(0).toLowerCase());
                    }
                    if (param == null) {
                        throw new InvalidDataAccessApiUsageException("Unable to locate declared parameter for function return value -  add a SqlOutParameter with name '" + this.getFunctionReturnName() + "'");
                    }
                    this.setFunctionReturnName(param.getName());
                } else {
                    param = (SqlParameter)declaredParams.get(paramNameToCheck);
                }
                if (param == null) continue;
                workParams.add(param);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Using declared parameter for '" + (paramNameToUse != null ? paramNameToUse : this.getFunctionReturnName()) + "'");
                continue;
            }
            if (meta.isReturnParameter()) {
                if (!this.isFunction() && !this.isReturnValueRequired() && this.metaDataProvider.byPassReturnParameter(meta.getParameterName())) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("Bypassing meta-data return parameter for '" + meta.getParameterName() + "'");
                    continue;
                }
                String returnNameToUse = StringUtils.hasLength(meta.getParameterName()) ? paramNameToUse : this.getFunctionReturnName();
                workParams.add(this.metaDataProvider.createDefaultOutParameter(returnNameToUse, meta));
                if (this.isFunction()) {
                    this.setFunctionReturnName(returnNameToUse);
                    outParamNames.add(returnNameToUse);
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Added meta-data return parameter for '" + returnNameToUse + "'");
                continue;
            }
            if (meta.getParameterType() == 4) {
                workParams.add(this.metaDataProvider.createDefaultOutParameter(paramNameToUse, meta));
                outParamNames.add(paramNameToUse);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Added meta-data out parameter for '" + paramNameToUse + "'");
                continue;
            }
            if (meta.getParameterType() == 2) {
                workParams.add(this.metaDataProvider.createDefaultInOutParameter(paramNameToUse, meta));
                outParamNames.add(paramNameToUse);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Added meta-data in-out parameter for '" + paramNameToUse + "'");
                continue;
            }
            if (this.limitedInParameterNames.isEmpty() || limitedInParamNamesMap.containsKey(paramNameToUse.toLowerCase())) {
                workParams.add(this.metaDataProvider.createDefaultInParameter(paramNameToUse, meta));
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Added meta-data in parameter for '" + paramNameToUse + "'");
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("Limited set of parameters " + limitedInParamNamesMap.keySet() + " skipped parameter for '" + paramNameToUse + "'");
        }
        return workParams;
    }

    public Map<String, Object> matchInParameterValuesWithCallParameters(SqlParameterSource parameterSource) {
        Map<String, String> caseInsensitiveParameterNames = SqlParameterSourceUtils.extractCaseInsensitiveParameterNames(parameterSource);
        HashMap<String, String> callParameterNames = new HashMap<String, String>(this.callParameters.size());
        HashMap<String, Object> matchedParameters = new HashMap<String, Object>(this.callParameters.size());
        for (SqlParameter parameter : this.callParameters) {
            if (!parameter.isInputValueProvided()) continue;
            String parameterName = parameter.getName();
            String parameterNameToMatch = this.metaDataProvider.parameterNameToUse(parameterName);
            if (parameterNameToMatch != null) {
                callParameterNames.put(parameterNameToMatch.toLowerCase(), parameterName);
            }
            if (parameterName == null) continue;
            if (parameterSource.hasValue(parameterName)) {
                matchedParameters.put(parameterName, SqlParameterSourceUtils.getTypedValue(parameterSource, parameterName));
                continue;
            }
            String lowerCaseName = parameterName.toLowerCase();
            if (parameterSource.hasValue(lowerCaseName)) {
                matchedParameters.put(parameterName, SqlParameterSourceUtils.getTypedValue(parameterSource, lowerCaseName));
                continue;
            }
            String englishLowerCaseName = parameterName.toLowerCase(Locale.ENGLISH);
            if (parameterSource.hasValue(englishLowerCaseName)) {
                matchedParameters.put(parameterName, SqlParameterSourceUtils.getTypedValue(parameterSource, englishLowerCaseName));
                continue;
            }
            String propertyName = JdbcUtils.convertUnderscoreNameToPropertyName(parameterName);
            if (parameterSource.hasValue(propertyName)) {
                matchedParameters.put(parameterName, SqlParameterSourceUtils.getTypedValue(parameterSource, propertyName));
                continue;
            }
            if (caseInsensitiveParameterNames.containsKey(lowerCaseName)) {
                String sourceName = caseInsensitiveParameterNames.get(lowerCaseName);
                matchedParameters.put(parameterName, SqlParameterSourceUtils.getTypedValue(parameterSource, sourceName));
                continue;
            }
            if (!this.logger.isWarnEnabled()) continue;
            this.logger.warn("Unable to locate the corresponding parameter value for '" + parameterName + "' within the parameter values provided: " + caseInsensitiveParameterNames.values());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Matching " + caseInsensitiveParameterNames.values() + " with " + callParameterNames.values());
            this.logger.debug("Found match for " + matchedParameters.keySet());
        }
        return matchedParameters;
    }

    public Map<String, ?> matchInParameterValuesWithCallParameters(Map<String, ?> inParameters) {
        String callParameterName;
        String parameterNameToMatch;
        if (!this.metaDataProvider.isProcedureColumnMetaDataUsed()) {
            return inParameters;
        }
        HashMap<String, String> callParameterNames = new HashMap<String, String>(this.callParameters.size());
        for (SqlParameter parameter : this.callParameters) {
            String parameterName;
            if (!parameter.isInputValueProvided() || (parameterNameToMatch = this.metaDataProvider.parameterNameToUse(parameterName = parameter.getName())) == null) continue;
            callParameterNames.put(parameterNameToMatch.toLowerCase(), parameterName);
        }
        HashMap matchedParameters = new HashMap(inParameters.size());
        for (String parameterName : inParameters.keySet()) {
            parameterNameToMatch = this.metaDataProvider.parameterNameToUse(parameterName);
            callParameterName = (String)callParameterNames.get(parameterNameToMatch.toLowerCase());
            if (callParameterName == null) {
                if (!this.logger.isDebugEnabled()) continue;
                Object value = inParameters.get(parameterName);
                if (value instanceof SqlParameterValue) {
                    value = ((SqlParameterValue)value).getValue();
                }
                if (value == null) continue;
                this.logger.debug("Unable to locate the corresponding IN or IN-OUT parameter for \"" + parameterName + "\" in the parameters used: " + callParameterNames.keySet());
                continue;
            }
            matchedParameters.put(callParameterName, inParameters.get(parameterName));
        }
        if (matchedParameters.size() < callParameterNames.size()) {
            for (String parameterName : callParameterNames.keySet()) {
                parameterNameToMatch = this.metaDataProvider.parameterNameToUse(parameterName);
                callParameterName = (String)callParameterNames.get(parameterNameToMatch.toLowerCase());
                if (matchedParameters.containsKey(callParameterName) || !this.logger.isWarnEnabled()) continue;
                this.logger.warn("Unable to locate the corresponding parameter value for '" + parameterName + "' within the parameter values provided: " + inParameters.keySet());
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Matching " + inParameters.keySet() + " with " + callParameterNames.values());
            this.logger.debug("Found match for " + matchedParameters.keySet());
        }
        return matchedParameters;
    }

    public Map<String, ?> matchInParameterValuesWithCallParameters(Object[] parameterValues) {
        HashMap<String, Object> matchedParameters = new HashMap<String, Object>(parameterValues.length);
        int i = 0;
        for (SqlParameter parameter : this.callParameters) {
            if (!parameter.isInputValueProvided()) continue;
            String parameterName = parameter.getName();
            matchedParameters.put(parameterName, parameterValues[i++]);
        }
        return matchedParameters;
    }

    public String createCallString() {
        StringBuilder callString;
        String catalogNameToUse;
        String schemaNameToUse;
        int parameterCount = 0;
        if (this.metaDataProvider.isSupportsSchemasInProcedureCalls() && !this.metaDataProvider.isSupportsCatalogsInProcedureCalls()) {
            schemaNameToUse = this.metaDataProvider.catalogNameToUse(this.getCatalogName());
            catalogNameToUse = this.metaDataProvider.schemaNameToUse(this.getSchemaName());
        } else {
            catalogNameToUse = this.metaDataProvider.catalogNameToUse(this.getCatalogName());
            schemaNameToUse = this.metaDataProvider.schemaNameToUse(this.getSchemaName());
        }
        String procedureNameToUse = this.metaDataProvider.procedureNameToUse(this.getProcedureName());
        if (this.isFunction() || this.isReturnValueRequired()) {
            callString = new StringBuilder().append("{? = call ").append(StringUtils.hasLength(catalogNameToUse) ? catalogNameToUse + "." : "").append(StringUtils.hasLength(schemaNameToUse) ? schemaNameToUse + "." : "").append(procedureNameToUse).append("(");
            parameterCount = -1;
        } else {
            callString = new StringBuilder().append("{call ").append(StringUtils.hasLength(catalogNameToUse) ? catalogNameToUse + "." : "").append(StringUtils.hasLength(schemaNameToUse) ? schemaNameToUse + "." : "").append(procedureNameToUse).append("(");
        }
        for (SqlParameter parameter : this.callParameters) {
            if (parameter.isResultsParameter()) continue;
            if (parameterCount > 0) {
                callString.append(", ");
            }
            if (parameterCount >= 0) {
                callString.append(this.createParameterBinding(parameter));
            }
            ++parameterCount;
        }
        callString.append(")}");
        return callString.toString();
    }

    protected String createParameterBinding(SqlParameter parameter) {
        return this.isNamedBinding() ? parameter.getName() + " => ?" : "?";
    }
}

