/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.metadata;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.metadata.GenericTableMetaDataProvider;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;
import org.springframework.util.ReflectionUtils;

public class OracleTableMetaDataProvider
extends GenericTableMetaDataProvider {
    private final boolean includeSynonyms;
    private String defaultSchema;

    public OracleTableMetaDataProvider(DatabaseMetaData databaseMetaData) throws SQLException {
        this(databaseMetaData, false);
    }

    public OracleTableMetaDataProvider(DatabaseMetaData databaseMetaData, boolean includeSynonyms) throws SQLException {
        super(databaseMetaData);
        this.includeSynonyms = includeSynonyms;
        this.defaultSchema = OracleTableMetaDataProvider.lookupDefaultSchema(databaseMetaData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String lookupDefaultSchema(DatabaseMetaData databaseMetaData) {
        try {
            Statement cstmt = null;
            try {
                Connection con = databaseMetaData.getConnection();
                if (con == null) {
                    logger.debug("Cannot check default schema - no Connection from DatabaseMetaData");
                    String string2 = null;
                    return string2;
                }
                cstmt = con.prepareCall("{? = call sys_context('USERENV', 'CURRENT_SCHEMA')}");
                cstmt.registerOutParameter(1, 12);
                cstmt.execute();
                String string = cstmt.getString(1);
                return string;
            }
            finally {
                if (cstmt != null) {
                    cstmt.close();
                }
            }
        }
        catch (SQLException ex) {
            logger.debug("Exception encountered during default schema lookup", ex);
            return null;
        }
    }

    @Override
    protected String getDefaultSchema() {
        if (this.defaultSchema != null) {
            return this.defaultSchema;
        }
        return super.getDefaultSchema();
    }

    @Override
    public void initializeWithTableColumnMetaData(DatabaseMetaData databaseMetaData, String catalogName, String schemaName, String tableName) throws SQLException {
        Method setIncludeSynonyms;
        Boolean originalValueForIncludeSynonyms;
        if (!this.includeSynonyms) {
            logger.debug("Defaulting to no synonyms in table meta-data lookup");
            super.initializeWithTableColumnMetaData(databaseMetaData, catalogName, schemaName, tableName);
            return;
        }
        Connection con = databaseMetaData.getConnection();
        if (con == null) {
            logger.warn("Unable to include synonyms in table meta-data lookup - no Connection from DatabaseMetaData");
            super.initializeWithTableColumnMetaData(databaseMetaData, catalogName, schemaName, tableName);
            return;
        }
        NativeJdbcExtractor nativeJdbcExtractor = this.getNativeJdbcExtractor();
        if (nativeJdbcExtractor != null) {
            con = nativeJdbcExtractor.getNativeConnection(con);
        }
        boolean isOracleCon = false;
        try {
            Class<?> oracleConClass = con.getClass().getClassLoader().loadClass("oracle.jdbc.OracleConnection");
            isOracleCon = oracleConClass.isInstance(con);
            if (!isOracleCon) {
                con = (Connection)con.unwrap(oracleConClass);
                isOracleCon = oracleConClass.isInstance(con);
            }
        }
        catch (ClassNotFoundException ex) {
            if (logger.isInfoEnabled()) {
                logger.info("Could not find Oracle JDBC API: " + ex);
            }
        }
        catch (SQLException ex) {
            // empty catch block
        }
        if (!isOracleCon) {
            if (logger.isWarnEnabled()) {
                logger.warn("Unable to include synonyms in table meta-data lookup - no Oracle Connection: " + con);
            }
            super.initializeWithTableColumnMetaData(databaseMetaData, catalogName, schemaName, tableName);
            return;
        }
        logger.debug("Including synonyms in table meta-data lookup");
        try {
            Method getIncludeSynonyms = con.getClass().getMethod("getIncludeSynonyms", new Class[0]);
            ReflectionUtils.makeAccessible(getIncludeSynonyms);
            originalValueForIncludeSynonyms = (Boolean)getIncludeSynonyms.invoke((Object)con, new Object[0]);
            setIncludeSynonyms = con.getClass().getMethod("setIncludeSynonyms", Boolean.TYPE);
            ReflectionUtils.makeAccessible(setIncludeSynonyms);
            setIncludeSynonyms.invoke((Object)con, Boolean.TRUE);
        }
        catch (Throwable ex) {
            throw new InvalidDataAccessApiUsageException("Could not prepare Oracle Connection", ex);
        }
        super.initializeWithTableColumnMetaData(databaseMetaData, catalogName, schemaName, tableName);
        try {
            setIncludeSynonyms.invoke((Object)con, originalValueForIncludeSynonyms);
        }
        catch (Throwable ex) {
            throw new InvalidDataAccessApiUsageException("Could not reset Oracle Connection", ex);
        }
    }
}

