/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authentication.dao;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.dao.SaltSource;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class ReflectionSaltSource
implements SaltSource,
InitializingBean {
    private String userPropertyToUse;

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.hasText(this.userPropertyToUse, "A userPropertyToUse must be set");
    }

    @Override
    public Object getSalt(UserDetails user) {
        Method saltMethod = this.findSaltMethod(user);
        try {
            return saltMethod.invoke((Object)user, new Object[0]);
        }
        catch (Exception exception) {
            throw new AuthenticationServiceException(exception.getMessage(), exception);
        }
    }

    private Method findSaltMethod(UserDetails user) {
        Method saltMethod = ReflectionUtils.findMethod(user.getClass(), this.userPropertyToUse, new Class[0]);
        if (saltMethod == null) {
            PropertyDescriptor pd = BeanUtils.getPropertyDescriptor(user.getClass(), this.userPropertyToUse);
            if (pd != null) {
                saltMethod = pd.getReadMethod();
            }
            if (saltMethod == null) {
                throw new AuthenticationServiceException("Unable to find salt method on user Object. Does the class '" + user.getClass().getName() + "' have a method or getter named '" + this.userPropertyToUse + "' ?");
            }
        }
        return saltMethod;
    }

    protected String getUserPropertyToUse() {
        return this.userPropertyToUse;
    }

    public void setUserPropertyToUse(String userPropertyToUse) {
        this.userPropertyToUse = userPropertyToUse;
    }

    public String toString() {
        return "ReflectionSaltSource[ userPropertyToUse='" + this.userPropertyToUse + "'; ]";
    }
}

