/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authentication.encoding;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.springframework.security.authentication.encoding.BaseDigestPasswordEncoder;
import org.springframework.security.authentication.encoding.PasswordEncoderUtils;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.security.crypto.codec.Hex;
import org.springframework.security.crypto.codec.Utf8;
import org.springframework.util.Assert;

@Deprecated
public class MessageDigestPasswordEncoder
extends BaseDigestPasswordEncoder {
    private final String algorithm;
    private int iterations = 1;

    public MessageDigestPasswordEncoder(String algorithm) {
        this(algorithm, false);
    }

    public MessageDigestPasswordEncoder(String algorithm, boolean encodeHashAsBase64) throws IllegalArgumentException {
        this.algorithm = algorithm;
        this.setEncodeHashAsBase64(encodeHashAsBase64);
        this.getMessageDigest();
    }

    @Override
    public String encodePassword(String rawPass, Object salt) {
        String saltedPass = this.mergePasswordAndSalt(rawPass, salt, false);
        MessageDigest messageDigest = this.getMessageDigest();
        byte[] digest = messageDigest.digest(Utf8.encode(saltedPass));
        for (int i = 1; i < this.iterations; ++i) {
            digest = messageDigest.digest(digest);
        }
        if (this.getEncodeHashAsBase64()) {
            return Utf8.decode(Base64.encode(digest));
        }
        return new String(Hex.encode(digest));
    }

    protected final MessageDigest getMessageDigest() throws IllegalArgumentException {
        try {
            return MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("No such algorithm [" + this.algorithm + "]");
        }
    }

    @Override
    public boolean isPasswordValid(String encPass, String rawPass, Object salt) {
        String pass1 = "" + encPass;
        String pass2 = this.encodePassword(rawPass, salt);
        return PasswordEncoderUtils.equals(pass1, pass2);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setIterations(int iterations) {
        Assert.isTrue(iterations > 0, "Iterations value must be greater than zero");
        this.iterations = iterations;
    }
}

