/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.ObjectError;

public class FieldError
extends ObjectError {
    private final String field;
    private final Object rejectedValue;
    private final boolean bindingFailure;

    public FieldError(String objectName, String field, String defaultMessage) {
        this(objectName, field, null, false, null, null, defaultMessage);
    }

    public FieldError(String objectName, String field, Object rejectedValue, boolean bindingFailure, String[] codes, Object[] arguments, String defaultMessage) {
        super(objectName, codes, arguments, defaultMessage);
        Assert.notNull(field, "Field must not be null");
        this.field = field;
        this.rejectedValue = rejectedValue;
        this.bindingFailure = bindingFailure;
    }

    public String getField() {
        return this.field;
    }

    public Object getRejectedValue() {
        return this.rejectedValue;
    }

    public boolean isBindingFailure() {
        return this.bindingFailure;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        FieldError otherError = (FieldError)other;
        return this.getField().equals(otherError.getField()) && ObjectUtils.nullSafeEquals(this.getRejectedValue(), otherError.getRejectedValue()) && this.isBindingFailure() == otherError.isBindingFailure();
    }

    @Override
    public int hashCode() {
        int hashCode2 = super.hashCode();
        hashCode2 = 29 * hashCode2 + this.getField().hashCode();
        hashCode2 = 29 * hashCode2 + ObjectUtils.nullSafeHashCode(this.getRejectedValue());
        hashCode2 = 29 * hashCode2 + (this.isBindingFailure() ? 1 : 0);
        return hashCode2;
    }

    @Override
    public String toString() {
        return "Field error in object '" + this.getObjectName() + "' on field '" + this.field + "': rejected value [" + ObjectUtils.nullSafeToString(this.rejectedValue) + "]; " + this.resolvableToString();
    }
}

