/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.dto.task;

import java.io.IOException;
import javax.xml.bind.annotation.XmlValue;
import org.apache.commons.lang3.StringUtils;
import org.duracloud.common.json.JaxbJsonSerializer;
import org.duracloud.snapshot.dto.BaseDTO;
import org.duracloud.snapshot.error.SnapshotDataException;

public class GetRestoreTaskParameters
extends BaseDTO {
    @XmlValue
    private String snapshotId;
    @XmlValue
    private String restoreId;

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(String snapshotId) {
        this.check(snapshotId, this.restoreId);
        this.snapshotId = snapshotId;
    }

    private void check(String snapshotId, String restoreId) {
        if (!StringUtils.isBlank((CharSequence)snapshotId) && !StringUtils.isBlank((CharSequence)restoreId)) {
            throw new IllegalArgumentException("EITHER a snapshotId or a restoreId may be set, but not both");
        }
    }

    public String getRestoreId() {
        return this.restoreId;
    }

    public void setRestoreId(String restoreId) {
        this.check(this.snapshotId, restoreId);
        this.restoreId = restoreId;
    }

    public String serialize() {
        JaxbJsonSerializer serializer = new JaxbJsonSerializer(GetRestoreTaskParameters.class);
        try {
            return serializer.serialize((Object)this);
        }
        catch (IOException e) {
            throw new SnapshotDataException("Unable to create task parameters due to: " + e.getMessage());
        }
    }

    public static GetRestoreTaskParameters deserialize(String taskParameters) {
        JaxbJsonSerializer serializer = new JaxbJsonSerializer(GetRestoreTaskParameters.class);
        try {
            GetRestoreTaskParameters params = (GetRestoreTaskParameters)serializer.deserialize(taskParameters);
            if (StringUtils.isBlank((CharSequence)params.getSnapshotId()) && StringUtils.isBlank((CharSequence)params.getRestoreId())) {
                throw new SnapshotDataException("Task parameter values may not be empty");
            }
            return params;
        }
        catch (IOException e) {
            throw new SnapshotDataException("Unable to parse task parameters due to: " + e.getMessage());
        }
    }
}

