/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.id;

import java.text.ParseException;
import org.duracloud.common.util.DateUtil;

public class SnapshotIdentifier {
    public static final String DELIM = "_";
    private String accountName;
    private String storeId;
    private String spaceId;
    private long timestamp;

    public SnapshotIdentifier(String accountName, String storeId, String spaceId, long timestamp) {
        this.accountName = accountName;
        this.storeId = storeId;
        this.spaceId = spaceId;
        this.timestamp = timestamp;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public String getSpaceId() {
        return this.spaceId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getSnapshotId() {
        return this.accountName + DELIM + this.storeId + DELIM + this.spaceId + DELIM + DateUtil.convertToStringPlain((long)this.timestamp);
    }

    public String getRestoreSpaceId() {
        Object spaceName = this.spaceId + "-" + DateUtil.convertToStringPlain((long)this.timestamp);
        if (((String)spaceName).length() > 42) {
            spaceName = ((String)spaceName).substring(0, 42);
        }
        if (((String)spaceName).endsWith("-")) {
            spaceName = ((String)spaceName).substring(0, ((String)spaceName).length() - 1);
        }
        return spaceName;
    }

    public static SnapshotIdentifier parseSnapshotId(String snapshotId) throws ParseException {
        String[] snapshotIdParts = snapshotId.split(DELIM);
        long timestamp = DateUtil.convertToDate((String)snapshotIdParts[3], (DateUtil.DateFormat)DateUtil.DateFormat.PLAIN_FORMAT).getTime();
        return new SnapshotIdentifier(snapshotIdParts[0], snapshotIdParts[1], snapshotIdParts[2], timestamp);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotIdentifier that = (SnapshotIdentifier)o;
        if (this.timestamp / 1000L != that.timestamp / 1000L) {
            return false;
        }
        if (!this.accountName.equals(that.accountName)) {
            return false;
        }
        if (!this.spaceId.equals(that.spaceId)) {
            return false;
        }
        return this.storeId.equals(that.storeId);
    }

    public int hashCode() {
        int result = this.accountName.hashCode();
        result = 31 * result + this.storeId.hashCode();
        result = 31 * result + this.spaceId.hashCode();
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }
}

