/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshottask.snapshot;

import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.BucketLifecycleConfiguration;
import java.util.ArrayList;
import org.duracloud.snapshot.dto.task.CleanupSnapshotTaskParameters;
import org.duracloud.snapshot.dto.task.CleanupSnapshotTaskResult;
import org.duracloud.snapshotstorage.SnapshotStorageProvider;
import org.duracloud.storage.provider.StorageProvider;
import org.duracloud.storage.provider.TaskRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupSnapshotTaskRunner
implements TaskRunner {
    private Logger log = LoggerFactory.getLogger(CleanupSnapshotTaskRunner.class);
    private static int EXPIRATION_DAYS = 1;
    private StorageProvider snapshotProvider;
    private SnapshotStorageProvider unwrappedSnapshotProvider;
    private AmazonS3Client s3Client;

    public CleanupSnapshotTaskRunner(StorageProvider snapshotProvider, SnapshotStorageProvider unwrappedSnapshotProvider, AmazonS3Client s3Client) {
        this.snapshotProvider = snapshotProvider;
        this.unwrappedSnapshotProvider = unwrappedSnapshotProvider;
        this.s3Client = s3Client;
    }

    public String getName() {
        return "cleanup-snapshot";
    }

    public String performTask(String taskParameters) {
        CleanupSnapshotTaskParameters taskParams = CleanupSnapshotTaskParameters.deserialize((String)taskParameters);
        String spaceId = taskParams.getSpaceId();
        String bucketName = this.unwrappedSnapshotProvider.getBucketName(spaceId);
        this.log.info("Performing Cleanup Snapshot Task for spaceID: " + spaceId);
        BucketLifecycleConfiguration.Rule expireRule = new BucketLifecycleConfiguration.Rule().withId("clear-content-rule").withExpirationInDays(EXPIRATION_DAYS).withStatus("Enabled".toString());
        ArrayList<BucketLifecycleConfiguration.Rule> rules = new ArrayList<BucketLifecycleConfiguration.Rule>();
        rules.add(expireRule);
        BucketLifecycleConfiguration configuration = new BucketLifecycleConfiguration().withRules(rules);
        this.s3Client.setBucketLifecycleConfiguration(bucketName, configuration);
        this.log.info("Cleanup Snapshot Task for space " + spaceId + " completed successfully");
        return new CleanupSnapshotTaskResult(EXPIRATION_DAYS).serialize();
    }
}

