/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshottask.snapshot;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.duracloud.common.model.AclType;
import org.duracloud.common.retry.Retriable;
import org.duracloud.common.retry.Retrier;
import org.duracloud.common.util.ChecksumUtil;
import org.duracloud.common.util.DateUtil;
import org.duracloud.common.util.IOUtil;
import org.duracloud.common.web.RestHttpHelper;
import org.duracloud.snapshot.dto.bridge.CreateSnapshotBridgeParameters;
import org.duracloud.snapshot.dto.bridge.CreateSnapshotBridgeResult;
import org.duracloud.snapshot.dto.task.CreateSnapshotTaskParameters;
import org.duracloud.snapshot.error.SnapshotDataException;
import org.duracloud.snapshot.id.SnapshotIdentifier;
import org.duracloud.snapshotstorage.SnapshotStorageProvider;
import org.duracloud.snapshottask.snapshot.AbstractSnapshotTaskRunner;
import org.duracloud.storage.error.TaskException;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateSnapshotTaskRunner
extends AbstractSnapshotTaskRunner {
    private Logger log = LoggerFactory.getLogger(CreateSnapshotTaskRunner.class);
    private StorageProvider snapshotProvider;
    private SnapshotStorageProvider unwrappedSnapshotProvider;
    private String dcAccountName;
    private String dcHost;
    private String dcPort;
    private String dcStoreId;
    private String dcSnapshotUser;

    public CreateSnapshotTaskRunner(StorageProvider snapshotProvider, SnapshotStorageProvider unwrappedSnapshotProvider, String dcHost, String dcPort, String dcStoreId, String dcAccountName, String dcSnapshotUser, String bridgeAppHost, String bridgeAppPort, String bridgeAppUser, String bridgeAppPass) {
        super(bridgeAppHost, bridgeAppPort, bridgeAppUser, bridgeAppPass);
        this.snapshotProvider = snapshotProvider;
        this.unwrappedSnapshotProvider = unwrappedSnapshotProvider;
        this.dcHost = dcHost;
        this.dcPort = dcPort;
        this.dcStoreId = dcStoreId;
        this.dcAccountName = dcAccountName;
        this.dcSnapshotUser = dcSnapshotUser;
    }

    public String getName() {
        return "create-snapshot";
    }

    public String performTask(String taskParameters) {
        String callResult;
        this.log.info("Performing SNAPSHOT task with parameters, DuraCloud Host: {} DuraCloud Port: {} DuraCloud StoreID: {} Account Name: {} DuraCloud Snapshot User: {} Bridge Host: {} Bridge Port: {} Bridge User: {}", new Object[]{this.dcHost, this.dcPort, this.dcStoreId, this.dcAccountName, this.dcSnapshotUser, this.getBridgeAppHost(), this.getBridgeAppPort(), this.getBridgeAppUser()});
        CreateSnapshotTaskParameters taskParams = CreateSnapshotTaskParameters.deserialize((String)taskParameters);
        String spaceId = taskParams.getSpaceId();
        long now = System.currentTimeMillis();
        String snapshotId = this.generateSnapshotId(spaceId, now);
        HashMap<String, String> snapshotProps = new HashMap<String, String>();
        snapshotProps.put("duracloud-host", this.dcHost);
        snapshotProps.put("duracloud-space-id", spaceId);
        snapshotProps.put("duracloud-store-id", this.dcStoreId);
        snapshotProps.put("snapshot-id", snapshotId);
        snapshotProps.put("snapshot-date", DateUtil.convertToStringVerbose((long)now));
        snapshotProps.put("owner-id", this.dcAccountName);
        snapshotProps.put("description", taskParams.getDescription());
        snapshotProps.put("user-email", taskParams.getUserEmail());
        String serializedProps = this.buildSnapshotProps(snapshotProps);
        this.storeSnapshotProps(spaceId, serializedProps);
        this.addSnapshotIdToSpaceProps(spaceId, snapshotId);
        this.setSnapshotUserPermissions(spaceId);
        String snapshotURL = this.buildSnapshotURL(snapshotId);
        try {
            String snapshotBody = this.buildSnapshotBody(taskParams);
            callResult = this.callBridge(this.createRestHelper(), snapshotURL, snapshotBody);
        }
        catch (SnapshotDataException | TaskException e) {
            try {
                this.removeSnapshotProps(spaceId);
                this.removeSnapshotIdFromSpaceProps(spaceId);
            }
            catch (Exception ex) {
                this.log.error("Failed to fully clean up snapshot props for " + spaceId + ": " + ex.getMessage(), (Throwable)ex);
            }
            String msg = MessageFormat.format("Call to create snapshot failed, snapshot properties have been removed from space {0}. Error message: {1}", spaceId, e.getMessage());
            throw new TaskException(msg, e);
        }
        CreateSnapshotBridgeResult bridgeResult = CreateSnapshotBridgeResult.deserialize((String)callResult);
        this.log.info("SNAPSHOT created with ID {} and status {}", (Object)bridgeResult.getSnapshotId(), (Object)bridgeResult.getStatus());
        return callResult;
    }

    protected String generateSnapshotId(String spaceId, long timestamp) {
        SnapshotIdentifier snapshotIdentifier = new SnapshotIdentifier(this.dcAccountName, this.dcStoreId, spaceId, timestamp);
        return snapshotIdentifier.getSnapshotId();
    }

    protected void addSnapshotIdToSpaceProps(String spaceId, String snapshotId) {
        Map spaceProps = this.snapshotProvider.getSpaceProperties(spaceId);
        spaceProps.put("snapshot-id", snapshotId);
        this.unwrappedSnapshotProvider.setNewSpaceProperties(spaceId, spaceProps);
    }

    protected void removeSnapshotIdFromSpaceProps(String spaceId) {
        this.log.debug("Removing snapshot-id property from space " + spaceId);
        Map spaceProps = this.snapshotProvider.getSpaceProperties(spaceId);
        if (spaceProps.remove("snapshot-id") != null) {
            this.unwrappedSnapshotProvider.setNewSpaceProperties(spaceId, spaceProps);
            this.log.info("Removed snapshot-id from  space properties for space " + spaceId);
        } else {
            this.log.debug("Property snapshot-id does not exist in space properties for " + spaceId + ". No need to update space properties.");
        }
    }

    protected String setSnapshotUserPermissions(final String spaceId) {
        try {
            Retrier retrier = new Retrier();
            return (String)retrier.execute(new Retriable(){

                public String retry() throws Exception {
                    Map spaceACLs = CreateSnapshotTaskRunner.this.snapshotProvider.getSpaceACLs(spaceId);
                    spaceACLs.put("acl-" + CreateSnapshotTaskRunner.this.dcSnapshotUser, AclType.READ);
                    CreateSnapshotTaskRunner.this.snapshotProvider.setSpaceACLs(spaceId, spaceACLs);
                    return spaceId;
                }
            });
        }
        catch (Exception e) {
            throw new TaskException("Unable to create snapshot, failedsetting space permissions due to: " + e.getMessage(), (Throwable)e);
        }
    }

    protected String buildSnapshotURL(String snapshotId) {
        return MessageFormat.format("{0}/snapshot/{1}", this.buildBridgeBaseURL(), snapshotId);
    }

    protected String buildSnapshotBody(CreateSnapshotTaskParameters taskParams) {
        CreateSnapshotBridgeParameters bridgeParams = new CreateSnapshotBridgeParameters(this.dcHost, this.dcPort, this.dcStoreId, taskParams.getSpaceId(), taskParams.getDescription(), taskParams.getUserEmail());
        return bridgeParams.serialize();
    }

    protected String buildSnapshotProps(Map<String, String> props) {
        Properties snapshotProperties = new Properties();
        for (String key : props.keySet()) {
            snapshotProperties.setProperty(key, props.get(key));
        }
        StringWriter writer = new StringWriter();
        try {
            snapshotProperties.store(writer, null);
        }
        catch (IOException e) {
            throw new TaskException("Could not write snapshot properties: " + e.getMessage(), (Throwable)e);
        }
        writer.flush();
        return writer.toString();
    }

    protected void storeSnapshotProps(String spaceId, String serializedProps) {
        InputStream propsStream;
        try {
            propsStream = IOUtil.writeStringToStream((String)serializedProps);
        }
        catch (IOException e) {
            throw new TaskException("Unable to build stream from serialized snapshot properties due to: " + e.getMessage());
        }
        ChecksumUtil checksumUtil = new ChecksumUtil(ChecksumUtil.Algorithm.MD5);
        String propsChecksum = checksumUtil.generateChecksum(serializedProps);
        this.snapshotProvider.addContent(spaceId, ".collection-snapshot.properties", "text/x-java-properties", null, (long)serializedProps.length(), propsChecksum, propsStream);
    }

    protected void removeSnapshotProps(String spaceId) {
        this.snapshotProvider.deleteContent(spaceId, ".collection-snapshot.properties");
    }

    protected String callBridge(RestHttpHelper restHelper, String snapshotURL, String snapshotBody) {
        this.log.info("Making SNAPSHOT call to URL {} with body {}", (Object)snapshotURL, (Object)snapshotBody);
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            RestHttpHelper.HttpResponse response = restHelper.put(snapshotURL, snapshotBody, headers);
            int statusCode = response.getStatusCode();
            if (statusCode != 200 && statusCode != 201) {
                throw new RuntimeException("Unexpected response code: " + statusCode);
            }
            return response.getResponseBody();
        }
        catch (Exception e) {
            throw new TaskException("Exception encountered attempting to initiate snapshot request. Error reported: " + e.getMessage(), (Throwable)e);
        }
    }
}

