/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshottask.snapshot;

import java.text.MessageFormat;
import org.duracloud.common.web.RestHttpHelper;
import org.duracloud.snapshottask.snapshot.AbstractSnapshotTaskRunner;
import org.duracloud.storage.error.TaskException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetSnapshotsTaskRunner
extends AbstractSnapshotTaskRunner {
    private Logger log = LoggerFactory.getLogger(GetSnapshotsTaskRunner.class);
    private String dcHost;

    public GetSnapshotsTaskRunner(String dcHost, String bridgeAppHost, String bridgeAppPort, String bridgeAppUser, String bridgeAppPass) {
        super(bridgeAppHost, bridgeAppPort, bridgeAppUser, bridgeAppPass);
        this.dcHost = dcHost;
    }

    public String getName() {
        return "get-snapshots";
    }

    public String performTask(String taskParameters) {
        return this.callBridge(this.createRestHelper(), this.buildBridgeURL());
    }

    protected String buildBridgeURL() {
        return MessageFormat.format("{0}/snapshot?host={1}", this.buildBridgeBaseURL(), this.dcHost);
    }

    protected String callBridge(RestHttpHelper restHelper, String bridgeURL) {
        this.log.info("Making bridge call to get snapshot list. URL: {}", (Object)bridgeURL);
        try {
            RestHttpHelper.HttpResponse response = restHelper.get(bridgeURL);
            int statusCode = response.getStatusCode();
            if (statusCode != 200) {
                throw new RuntimeException("Unexpected response code: " + statusCode);
            }
            return response.getResponseBody();
        }
        catch (Exception e) {
            throw new TaskException("Exception encountered attempting to get list of snapshots. Error reported: " + e.getMessage(), (Throwable)e);
        }
    }
}

