/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshottask.snapshot;

import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.BucketLifecycleConfiguration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.duracloud.audit.task.AuditTask;
import org.duracloud.common.queue.TaskQueue;
import org.duracloud.common.queue.task.Task;
import org.duracloud.mill.db.model.ManifestItem;
import org.duracloud.mill.manifest.ManifestStore;
import org.duracloud.snapshot.dto.task.CleanupSnapshotTaskParameters;
import org.duracloud.snapshot.dto.task.CleanupSnapshotTaskResult;
import org.duracloud.snapshotstorage.SnapshotStorageProvider;
import org.duracloud.storage.domain.StorageProviderType;
import org.duracloud.storage.provider.TaskRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;

public class CleanupSnapshotTaskRunner
implements TaskRunner {
    private Logger log = LoggerFactory.getLogger(CleanupSnapshotTaskRunner.class);
    private static int EXPIRATION_DAYS = 1;
    private SnapshotStorageProvider unwrappedSnapshotProvider;
    private AmazonS3Client s3Client;
    private TaskQueue auditTaskQueue;
    private ManifestStore manifestStore;
    private String account;
    private String storeId;

    public CleanupSnapshotTaskRunner(SnapshotStorageProvider unwrappedSnapshotProvider, AmazonS3Client s3Client, TaskQueue auditTaskQueue, ManifestStore manifestStore, String account, String storeId) {
        this.unwrappedSnapshotProvider = unwrappedSnapshotProvider;
        this.s3Client = s3Client;
        this.auditTaskQueue = auditTaskQueue;
        this.manifestStore = manifestStore;
        this.storeId = storeId;
        this.account = account;
    }

    public String getName() {
        return "cleanup-snapshot";
    }

    public String performTask(String taskParameters) {
        CleanupSnapshotTaskParameters taskParams = CleanupSnapshotTaskParameters.deserialize((String)taskParameters);
        String spaceId = taskParams.getSpaceId();
        String bucketName = this.unwrappedSnapshotProvider.getBucketName(spaceId);
        this.log.info("Performing Cleanup Snapshot Task for spaceID: " + spaceId);
        BucketLifecycleConfiguration.Rule expireRule = new BucketLifecycleConfiguration.Rule().withId("clear-content-rule").withExpirationInDays(EXPIRATION_DAYS).withStatus("Enabled".toString());
        ArrayList<BucketLifecycleConfiguration.Rule> rules = new ArrayList<BucketLifecycleConfiguration.Rule>();
        rules.add(expireRule);
        BucketLifecycleConfiguration configuration = new BucketLifecycleConfiguration().withRules(rules);
        this.s3Client.setBucketLifecycleConfiguration(bucketName, configuration);
        Iterator items = this.manifestStore.getItems(this.account, this.storeId, spaceId);
        long count = 0L;
        HashSet<Task> tasks = new HashSet<Task>();
        String userId = SecurityContextHolder.getContext().getAuthentication().getName();
        while (items.hasNext()) {
            ManifestItem item = (ManifestItem)items.next();
            AuditTask task = new AuditTask();
            task.setAccount(this.account);
            task.setSpaceId(spaceId);
            task.setStoreId(this.storeId);
            task.setDateTime(String.valueOf(System.currentTimeMillis()));
            task.setContentId(item.getContentId());
            task.setContentSize(item.getContentSize());
            task.setStoreType(StorageProviderType.SNAPSHOT.name());
            task.setContentChecksum(item.getContentChecksum());
            task.setAction(AuditTask.ActionType.DELETE_CONTENT.name());
            task.setUserId(userId);
            tasks.add(task.writeTask());
            if (tasks.size() >= 10) {
                this.auditTaskQueue.put(tasks);
                tasks = new HashSet();
            }
            ++count;
        }
        if (tasks.size() > 0) {
            this.auditTaskQueue.put(tasks);
        }
        this.log.info("Added {} delete audit tasks.", (Object)count);
        this.log.info("Cleanup Snapshot Task for space " + spaceId + " completed successfully");
        return new CleanupSnapshotTaskResult(EXPIRATION_DAYS).serialize();
    }
}

