/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshottask.snapshot;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.HashMap;
import org.duracloud.common.web.RestHttpHelper;
import org.duracloud.snapshot.dto.bridge.RequestRestoreBridgeParameters;
import org.duracloud.snapshot.dto.bridge.RequestRestoreBridgeResult;
import org.duracloud.snapshot.dto.task.RequestRestoreSnapshotParameters;
import org.duracloud.snapshot.dto.task.RequestRestoreSnapshotTaskResult;
import org.duracloud.snapshot.id.SnapshotIdentifier;
import org.duracloud.snapshottask.snapshot.AbstractSnapshotTaskRunner;
import org.duracloud.storage.error.TaskException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestRestoreSnapshotTaskRunner
extends AbstractSnapshotTaskRunner {
    private Logger log = LoggerFactory.getLogger(RequestRestoreSnapshotTaskRunner.class);
    private String dcHost;
    private String dcPort;
    private String dcStoreId;
    private String dcSnapshotUser;

    public RequestRestoreSnapshotTaskRunner(String dcHost, String dcPort, String dcStoreId, String dcSnapshotUser, String bridgeAppHost, String bridgeAppPort, String bridgeAppUser, String bridgeAppPass) {
        super(bridgeAppHost, bridgeAppPort, bridgeAppUser, bridgeAppPass);
        this.dcHost = dcHost;
        this.dcPort = dcPort;
        this.dcStoreId = dcStoreId;
        this.dcSnapshotUser = dcSnapshotUser;
    }

    public String getName() {
        return "request-restore-snapshot";
    }

    public String performTask(String taskParameters) {
        this.log.info("Performing restore request task with parameters, DuraCloud Host: {} DuraCloud Port: {} DuraCloud StoreID: {} DuraCloud Snapshot User: {} Bridge Host: {} Bridge Port: {} Bridge User: {}", new Object[]{this.dcHost, this.dcPort, this.dcStoreId, this.dcSnapshotUser, this.getBridgeAppHost(), this.getBridgeAppPort(), this.getBridgeAppUser()});
        RequestRestoreSnapshotParameters taskParams = RequestRestoreSnapshotParameters.deserialize((String)taskParameters);
        String snapshotId = taskParams.getSnapshotId();
        try {
            SnapshotIdentifier snapshotIdentifier = SnapshotIdentifier.parseSnapshotId((String)snapshotId);
        }
        catch (ParseException e) {
            throw new TaskException("Invalid Snapshot ID: " + snapshotId);
        }
        String bridgeURL = this.buildBridgeURL();
        String bridgeBody = this.buildBridgeBody(snapshotId, taskParams.getUserEmail());
        String callResult = this.callBridge(this.createRestHelper(), bridgeURL, bridgeBody);
        RequestRestoreBridgeResult bridgeResult = RequestRestoreBridgeResult.deserialize((String)callResult);
        RequestRestoreSnapshotTaskResult taskResult = new RequestRestoreSnapshotTaskResult();
        taskResult.setDescription(bridgeResult.getDescription());
        return taskResult.serialize();
    }

    protected String buildBridgeURL() {
        return MessageFormat.format("{0}/restore/request", this.buildBridgeBaseURL());
    }

    protected String buildBridgeBody(String snapshotId, String userEmail) {
        RequestRestoreBridgeParameters bridgeParams = new RequestRestoreBridgeParameters(this.dcHost, this.dcPort, this.dcStoreId, snapshotId, userEmail);
        return bridgeParams.serialize();
    }

    protected String callBridge(RestHttpHelper restHelper, String snapshotURL, String snapshotBody) {
        this.log.info("Making RESTORE call to URL {} with body {}", (Object)snapshotURL, (Object)snapshotBody);
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            RestHttpHelper.HttpResponse response = restHelper.put(snapshotURL, snapshotBody, headers);
            int statusCode = response.getStatusCode();
            if (statusCode != 201) {
                throw new RuntimeException("Unexpected response code: " + statusCode);
            }
            return response.getResponseBody();
        }
        catch (Exception e) {
            throw new TaskException("Exception encountered attempting to initiate snapshot request. Error reported: " + e.getMessage(), (Throwable)e);
        }
    }
}

