/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshottask.snapshot;

import java.text.MessageFormat;
import org.duracloud.common.web.RestHttpHelper;
import org.duracloud.snapshot.dto.task.GetRestoreTaskParameters;
import org.duracloud.snapshottask.snapshot.AbstractSnapshotTaskRunner;
import org.duracloud.storage.error.TaskException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetRestoreTaskRunner
extends AbstractSnapshotTaskRunner {
    private Logger log = LoggerFactory.getLogger(GetRestoreTaskRunner.class);

    public GetRestoreTaskRunner(String bridgeAppHost, String bridgeAppPort, String bridgeAppUser, String bridgeAppPass) {
        super(bridgeAppHost, bridgeAppPort, bridgeAppUser, bridgeAppPass);
    }

    public String getName() {
        return "get-restore";
    }

    public String performTask(String taskParameters) {
        GetRestoreTaskParameters params = GetRestoreTaskParameters.deserialize((String)taskParameters);
        return this.callBridge(this.createRestHelper(), this.buildBridgeURL(params));
    }

    protected String buildBridgeURL(GetRestoreTaskParameters params) {
        if (params.getRestoreId() != null) {
            return MessageFormat.format("{0}/restore/{1}", this.buildBridgeBaseURL(), params.getRestoreId());
        }
        return MessageFormat.format("{0}/restore/by-snapshot/{1}", this.buildBridgeBaseURL(), params.getSnapshotId());
    }

    protected String callBridge(RestHttpHelper restHelper, String bridgeURL) {
        this.log.info("Making bridge call to get restore status. URL: {}", (Object)bridgeURL);
        try {
            RestHttpHelper.HttpResponse response = restHelper.get(bridgeURL);
            int statusCode = response.getStatusCode();
            if (statusCode != 200) {
                throw new RuntimeException("Unexpected response code: " + statusCode);
            }
            return response.getResponseBody();
        }
        catch (Exception e) {
            throw new TaskException("Exception encountered attempting to get restore. Error reported: " + e.getMessage(), (Throwable)e);
        }
    }
}

