/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshottask.snapshot;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import org.duracloud.common.model.AclType;
import org.duracloud.common.retry.Retriable;
import org.duracloud.common.retry.Retrier;
import org.duracloud.common.util.ChecksumUtil;
import org.duracloud.common.util.IOUtil;
import org.duracloud.snapshotstorage.SnapshotStorageProvider;
import org.duracloud.snapshottask.snapshot.AbstractSnapshotTaskRunner;
import org.duracloud.storage.error.NotFoundException;
import org.duracloud.storage.error.TaskException;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SpaceModifyingSnapshotTaskRunner
extends AbstractSnapshotTaskRunner {
    private Logger log = LoggerFactory.getLogger(SpaceModifyingSnapshotTaskRunner.class);
    private StorageProvider snapshotProvider;
    private SnapshotStorageProvider unwrappedSnapshotProvider;
    private String dcSnapshotUser;

    public SpaceModifyingSnapshotTaskRunner(StorageProvider snapshotProvider, SnapshotStorageProvider unwrappedSnapshotProvider, String dcSnapshotUser, String bridgeAppHost, String bridgeAppPort, String bridgeAppUser, String bridgeAppPass) {
        super(bridgeAppHost, bridgeAppPort, bridgeAppUser, bridgeAppPass);
        this.snapshotProvider = snapshotProvider;
        this.unwrappedSnapshotProvider = unwrappedSnapshotProvider;
        this.dcSnapshotUser = dcSnapshotUser;
    }

    protected StorageProvider getStorageProvider() {
        return this.snapshotProvider;
    }

    protected String getSnapshotUser() {
        return this.dcSnapshotUser;
    }

    protected void addSnapshotIdToSpaceProps(String spaceId, String snapshotId) {
        Map spaceProps = this.snapshotProvider.getSpaceProperties(spaceId);
        spaceProps.put("snapshot-id", snapshotId);
        this.unwrappedSnapshotProvider.setNewSpaceProperties(spaceId, spaceProps);
    }

    protected void storeSnapshotProps(String spaceId, String serializedProps) {
        InputStream propsStream;
        try {
            propsStream = IOUtil.writeStringToStream((String)serializedProps);
        }
        catch (IOException e) {
            throw new TaskException("Unable to build stream from serialized snapshot properties due to: " + e.getMessage());
        }
        ChecksumUtil checksumUtil = new ChecksumUtil(ChecksumUtil.Algorithm.MD5);
        String propsChecksum = checksumUtil.generateChecksum(serializedProps);
        this.snapshotProvider.addContent(spaceId, ".collection-snapshot.properties", "text/x-java-properties", null, (long)serializedProps.length(), propsChecksum, propsStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getSnapshotIdFromProperties(String spaceId) {
        Properties props = new Properties();
        try (InputStream is = this.snapshotProvider.getContent(spaceId, ".collection-snapshot.properties");){
            props.load(is);
            String string = props.getProperty("snapshot-id");
            return string;
        }
        catch (NotFoundException ex) {
            return null;
        }
        catch (Exception e) {
            throw new TaskException(MessageFormat.format("Call to create snapshot failed, unable to determine existence of snapshot properties file in {0}. Error: {1}", spaceId, e.getMessage()));
        }
    }

    protected void removeSnapshotIdFromSpaceProps(String spaceId) {
        this.log.debug("Removing snapshot-id property from space " + spaceId);
        Map spaceProps = this.snapshotProvider.getSpaceProperties(spaceId);
        if (spaceProps.remove("snapshot-id") != null) {
            this.unwrappedSnapshotProvider.setNewSpaceProperties(spaceId, spaceProps);
            this.log.info("Removed snapshot-id from  space properties for space " + spaceId);
        } else {
            this.log.debug("Property snapshot-id does not exist in space properties for " + spaceId + ". No need to update space properties.");
        }
    }

    protected String setSnapshotUserPermissions(final String spaceId) {
        try {
            Retrier retrier = new Retrier();
            return (String)retrier.execute(new Retriable(){

                public String retry() throws Exception {
                    Map spaceACLs = SpaceModifyingSnapshotTaskRunner.this.snapshotProvider.getSpaceACLs(spaceId);
                    spaceACLs.put("acl-" + SpaceModifyingSnapshotTaskRunner.this.dcSnapshotUser, AclType.READ);
                    SpaceModifyingSnapshotTaskRunner.this.snapshotProvider.setSpaceACLs(spaceId, spaceACLs);
                    return spaceId;
                }
            });
        }
        catch (Exception e) {
            throw new TaskException("Unable to create snapshot, failedsetting space permissions due to: " + e.getMessage(), (Throwable)e);
        }
    }

    protected String removeSnapshotUserPermissions(final String spaceId) {
        try {
            Retrier retrier = new Retrier();
            return (String)retrier.execute(new Retriable(){

                public String retry() throws Exception {
                    Map spaceACLs = SpaceModifyingSnapshotTaskRunner.this.snapshotProvider.getSpaceACLs(spaceId);
                    spaceACLs.remove("acl-" + SpaceModifyingSnapshotTaskRunner.this.dcSnapshotUser);
                    SpaceModifyingSnapshotTaskRunner.this.snapshotProvider.setSpaceACLs(spaceId, spaceACLs);
                    return spaceId;
                }
            });
        }
        catch (Exception e) {
            throw new TaskException("Failedto remove read only permissions for snapshot user due to: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void removeSnapshotProps(String spaceId) {
        this.snapshotProvider.deleteContent(spaceId, ".collection-snapshot.properties");
    }

    protected boolean snapshotPropsPresentInSpace(String spaceId) {
        try {
            this.snapshotProvider.getContentProperties(spaceId, ".collection-snapshot.properties");
            return true;
        }
        catch (NotFoundException ex) {
            return false;
        }
    }
}

