/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshottask.snapshot;

import java.text.MessageFormat;
import org.duracloud.common.web.RestHttpHelper;
import org.duracloud.snapshot.dto.task.GetSnapshotTaskParameters;
import org.duracloud.snapshottask.snapshot.AbstractSnapshotTaskRunner;
import org.duracloud.storage.error.TaskException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetSnapshotTaskRunner
extends AbstractSnapshotTaskRunner {
    private Logger log = LoggerFactory.getLogger(GetSnapshotTaskRunner.class);

    public GetSnapshotTaskRunner(String bridgeAppHost, String bridgeAppPort, String bridgeAppUser, String bridgeAppPass) {
        super(bridgeAppHost, bridgeAppPort, bridgeAppUser, bridgeAppPass);
    }

    public String getName() {
        return "get-snapshot";
    }

    public String performTask(String taskParameters) {
        GetSnapshotTaskParameters params = GetSnapshotTaskParameters.deserialize((String)taskParameters);
        String snapshotId = params.getSnapshotId();
        return this.callBridge(this.createRestHelper(), this.buildBridgeURL(snapshotId));
    }

    protected String buildBridgeURL(String snapshotId) {
        return MessageFormat.format("{0}/snapshot/{1}", this.buildBridgeBaseURL(), snapshotId);
    }

    protected String callBridge(RestHttpHelper restHelper, String bridgeURL) {
        this.log.info("Making bridge call to get snapshot status. URL: {}", (Object)bridgeURL);
        try {
            RestHttpHelper.HttpResponse response = restHelper.get(bridgeURL);
            int statusCode = response.getStatusCode();
            if (statusCode != 200) {
                throw new RuntimeException("Unexpected response code: " + statusCode);
            }
            return response.getResponseBody();
        }
        catch (Exception e) {
            throw new TaskException("Exception encountered attempting to get  snapshot. Error reported: " + e.getMessage(), (Throwable)e);
        }
    }
}

