/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshottask.snapshot;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.duracloud.account.db.model.Role;
import org.duracloud.common.web.RestHttpHelper;
import org.duracloud.snapshot.dto.SnapshotSummary;
import org.duracloud.snapshot.dto.bridge.GetSnapshotListBridgeResult;
import org.duracloud.snapshottask.snapshot.AbstractSnapshotTaskRunner;
import org.duracloud.storage.error.TaskException;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class GetSnapshotsTaskRunner
extends AbstractSnapshotTaskRunner {
    private Logger log = LoggerFactory.getLogger(GetSnapshotsTaskRunner.class);
    private String dcHost;
    private String dcStoreId;
    private StorageProvider storageProvider;

    public GetSnapshotsTaskRunner(String dcHost, String dcStoreId, String bridgeAppHost, String bridgeAppPort, String bridgeAppUser, String bridgeAppPass, StorageProvider storageProvider) {
        super(bridgeAppHost, bridgeAppPort, bridgeAppUser, bridgeAppPass);
        this.dcHost = dcHost;
        this.dcStoreId = dcStoreId;
        this.storageProvider = storageProvider;
    }

    public String getName() {
        return "get-snapshots";
    }

    public String performTask(String taskParameters) {
        String result = this.callBridge(this.createRestHelper(), this.buildBridgeURL());
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (!auth.getAuthorities().contains(Role.ROLE_ADMIN.authority())) {
            GetSnapshotListBridgeResult list = GetSnapshotListBridgeResult.deserialize((String)result);
            LinkedList<SnapshotSummary> filteredSnapshots = new LinkedList<SnapshotSummary>();
            Iterator it = this.storageProvider.getSpaces();
            HashSet<String> spaceSet = new HashSet<String>();
            while (it.hasNext()) {
                spaceSet.add((String)it.next());
            }
            for (SnapshotSummary snapshot : list.getSnapshots()) {
                if (!spaceSet.contains(snapshot.getSourceSpaceId())) continue;
                filteredSnapshots.add(snapshot);
            }
            list.setSnapshots(filteredSnapshots);
            result = list.serialize();
        }
        return result;
    }

    protected String buildBridgeURL() {
        return MessageFormat.format("{0}/snapshot?host={1}&storeId={2}", this.buildBridgeBaseURL(), this.dcHost, this.dcStoreId);
    }

    protected String callBridge(RestHttpHelper restHelper, String bridgeURL) {
        this.log.info("Making bridge call to get snapshot list. URL: {}", (Object)bridgeURL);
        try {
            RestHttpHelper.HttpResponse response = restHelper.get(bridgeURL);
            int statusCode = response.getStatusCode();
            if (statusCode != 200) {
                throw new RuntimeException("Unexpected response code: " + statusCode);
            }
            return response.getResponseBody();
        }
        catch (Exception e) {
            throw new TaskException("Exception encountered attempting to get list of snapshots. Error reported: " + e.getMessage(), (Throwable)e);
        }
    }
}

