/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.stitch;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.duracloud.chunk.FileChunker;
import org.duracloud.client.ContentStore;
import org.duracloud.client.ContentStoreManagerImpl;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.common.model.Credential;
import org.duracloud.domain.Content;
import org.duracloud.error.ContentStoreException;
import org.duracloud.stitch.FileStitcher;
import org.duracloud.stitch.datasource.DataSource;
import org.duracloud.stitch.datasource.impl.DuraStoreDataSource;
import org.duracloud.stitch.impl.FileStitcherImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStitcherDriver {
    private Logger log = LoggerFactory.getLogger(FileStitcherDriver.class);
    private FileStitcher stitcher;

    public FileStitcherDriver(DataSource dataSource) {
        this.stitcher = new FileStitcherImpl(dataSource);
    }

    public void stitch(String spaceId, String manifestId, File toDir) throws Exception {
        this.verifyDir(toDir);
        Content content = this.stitcher.getContentFromManifest(spaceId, manifestId);
        this.writeContentToDir(content, toDir);
    }

    private void verifyDir(File dir) throws Exception {
        if (!dir.isDirectory() && !dir.mkdirs()) {
            throw new DuraCloudRuntimeException("Invalid dir: " + dir);
        }
        try {
            File tmp = new File(dir, "remove-me.txt");
            FileOutputStream fos = new FileOutputStream(tmp);
            fos.write("hello".getBytes());
            IOUtils.closeQuietly((OutputStream)fos);
            FileUtils.deleteQuietly((File)tmp);
        }
        catch (IOException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("User must have permissions to write to the directory: ");
            sb.append(dir.getAbsolutePath());
            throw new Exception(sb.toString(), e);
        }
    }

    private void writeContentToDir(Content content, File toDir) {
        File outFile = new File(toDir, content.getId());
        this.log.info("Writing to '{}'.", (Object)outFile.getAbsolutePath());
        FileOutputStream outputStream = null;
        try {
            File parentDir = outFile.getParentFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
                parentDir.setWritable(true);
            }
            outputStream = new FileOutputStream(outFile);
            IOUtils.copyLarge((InputStream)content.getStream(), (OutputStream)outputStream);
        }
        catch (IOException e) {
            try {
                StringBuilder msg = new StringBuilder();
                msg.append("Error writing content: ");
                msg.append(content.getId());
                msg.append(" to output file: ");
                msg.append(outFile.getAbsolutePath());
                throw new DuraCloudRuntimeException(msg.toString(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    private static Options getOptions() {
        Option host = new Option("h", "host", true, "hostname of duracloud instance");
        Option port = new Option("r", "port", true, "port of duracloud instance");
        Option username = new Option("u", "username", true, "username of duracloud instance");
        Option password = new Option("p", "password", true, "password of duracloud instance");
        Option storeId = new Option("i", "store-id", true, "store-id of duracloud storage provider");
        Option spaceId = new Option("s", "space-id", true, "space-id of duracloud space where manifest and chunks reside");
        Option manifestId = new Option("m", "manifest-id", true, "manifest-id of chunks manifest");
        Option toDir = new Option("d", "to-dir", true, "destination directory of full content");
        host.setRequired(true);
        port.setRequired(false);
        username.setRequired(true);
        password.setRequired(true);
        storeId.setRequired(false);
        spaceId.setRequired(true);
        manifestId.setRequired(true);
        toDir.setRequired(true);
        Options options = new Options();
        options.addOption(host);
        options.addOption(port);
        options.addOption(username);
        options.addOption(password);
        options.addOption(storeId);
        options.addOption(spaceId);
        options.addOption(manifestId);
        options.addOption(toDir);
        return options;
    }

    private static CommandLine parseArgs(String[] args) {
        GnuParser parser = new GnuParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(FileStitcherDriver.getOptions(), args);
        }
        catch (ParseException e) {
            System.err.println((Object)e);
            FileStitcherDriver.die();
        }
        return cmd;
    }

    private static void usage() {
        HelpFormatter help = new HelpFormatter();
        help.setWidth(80);
        help.printHelp(FileChunker.class.getCanonicalName(), FileStitcherDriver.getOptions());
    }

    private static void die() {
        FileStitcherDriver.usage();
        System.exit(1);
    }

    public static void main(String[] args) {
        CommandLine cmd = FileStitcherDriver.parseArgs(args);
        String spaceId = cmd.getOptionValue("space-id");
        String manifestId = cmd.getOptionValue("manifest-id");
        String toDir = cmd.getOptionValue("to-dir");
        try {
            DataSource dataSource = FileStitcherDriver.getDataSource(cmd);
            FileStitcherDriver driver = new FileStitcherDriver(dataSource);
            driver.stitch(spaceId, manifestId, new File(toDir));
        }
        catch (Exception e) {
            System.err.println("Error stitching content: " + e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        System.out.println("Successfully downloaded: " + spaceId + "/" + manifestId);
    }

    private static DataSource getDataSource(CommandLine cmd) throws ContentStoreException {
        String host = cmd.getOptionValue("host");
        String port = "443";
        if (cmd.hasOption("port")) {
            port = cmd.getOptionValue("port");
        }
        String username = cmd.getOptionValue("username");
        String password = cmd.getOptionValue("password");
        ContentStoreManagerImpl mgr = new ContentStoreManagerImpl(host, port);
        mgr.login(FileStitcherDriver.getCredentials(username, password));
        ContentStore contentStore = cmd.hasOption("store-id") ? mgr.getContentStore(cmd.getOptionValue("store-id")) : mgr.getPrimaryContentStore();
        return new DuraStoreDataSource(contentStore);
    }

    private static Credential getCredentials(String username, String password) {
        if (null == username || null == password) {
            String border = "**************\n";
            StringBuilder msg = new StringBuilder(border);
            msg.append("If either username or password are provided,\n");
            msg.append("they both must be provided.\n");
            msg.append(border);
            System.out.println(msg);
            FileStitcherDriver.die();
        }
        return new Credential(username, password);
    }
}

