/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.stitch.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.duracloud.chunk.manifest.ChunksManifest;
import org.duracloud.chunk.manifest.ChunksManifestBean;
import org.duracloud.chunk.manifest.xml.ManifestDocumentBinding;
import org.duracloud.common.model.ContentItem;
import org.duracloud.domain.Content;
import org.duracloud.stitch.FileStitcher;
import org.duracloud.stitch.FileStitcherListener;
import org.duracloud.stitch.datasource.DataSource;
import org.duracloud.stitch.error.DataSourceException;
import org.duracloud.stitch.error.InvalidManifestException;
import org.duracloud.stitch.stream.MultiContentInputStream;
import org.duracloud.stitch.stream.MultiContentInputStreamListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStitcherImpl
implements FileStitcher {
    private Logger log = LoggerFactory.getLogger(FileStitcherImpl.class);
    private DataSource dataSource;

    public FileStitcherImpl(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public Content getContentFromManifest(String spaceId, String contentId, FileStitcherListener listener) throws InvalidManifestException, DataSourceException {
        this.log.debug("getContentFromManifest({}, {})", (Object)spaceId, (Object)contentId);
        if (!this.isManifest(contentId)) {
            this.log.error("Invalid manifest name: {}", (Object)contentId);
            throw new InvalidManifestException(spaceId, contentId);
        }
        Content manifestContent = this.dataSource.getContent(spaceId, contentId);
        ChunksManifest manifest = this.getManifest(manifestContent, spaceId, contentId);
        InputStream multiStream = this.getChunkSequenceStream(spaceId, manifest, listener);
        Content content = new Content();
        content.setStream(multiStream);
        content.setId(manifest.getHeader().getSourceContentId());
        Map<String, String> stitchedProps = this.getContentProperties(manifest);
        Map<String, String> manifestProps = manifestContent.getProperties();
        if (manifestProps == null) {
            manifestProps = stitchedProps;
        } else {
            manifestProps.putAll(stitchedProps);
        }
        content.setProperties(manifestProps);
        return content;
    }

    private boolean isManifest(String contentId) {
        return null != contentId && contentId.endsWith(".dura-manifest");
    }

    @Override
    public ChunksManifest getManifest(String spaceId, String manifestId) throws InvalidManifestException {
        return this.getManifest(this.dataSource.getContent(spaceId, manifestId), spaceId, manifestId);
    }

    private ChunksManifest getManifest(Content content, String spaceId, String manifestId) throws InvalidManifestException {
        ChunksManifest chunksManifest;
        block9: {
            if (null == content) {
                String msg = "No content found!";
                this.log.error(msg);
                throw new InvalidManifestException(spaceId, manifestId, msg);
            }
            InputStream is = content.getStream();
            try {
                chunksManifest = ManifestDocumentBinding.createManifestFrom((InputStream)is);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    String msg = "Error deserializing manifest!";
                    this.log.error(msg);
                    throw new InvalidManifestException(spaceId, manifestId, msg, e);
                }
            }
            is.close();
        }
        return chunksManifest;
    }

    private InputStream getChunkSequenceStream(String spaceId, ChunksManifest manifest, final FileStitcherListener listener) throws InvalidManifestException {
        TreeMap<Integer, String> sortedChunkIds = new TreeMap<Integer, String>();
        for (Object entry : manifest.getEntries()) {
            sortedChunkIds.put(entry.getIndex(), entry.getChunkId());
        }
        ArrayList<ContentItem> chunks = new ArrayList<ContentItem>();
        for (String chunkId : sortedChunkIds.values()) {
            chunks.add(new ContentItem(spaceId, chunkId));
        }
        if (chunks.size() == 0) {
            String msg = "No chunk streams found!";
            this.log.error(msg);
            String contentId = manifest.getHeader().getSourceContentId();
            throw new InvalidManifestException(spaceId, contentId, msg);
        }
        MultiContentInputStreamListener contentListener = new MultiContentInputStreamListener(){

            @Override
            public void contentIdRead(String contentId) {
                if (listener != null) {
                    listener.chunkStitched(contentId);
                }
            }
        };
        return new MultiContentInputStream(this.dataSource, chunks, contentListener);
    }

    private Map<String, String> getContentProperties(ChunksManifest manifest) {
        HashMap<String, String> props = new HashMap<String, String>();
        ChunksManifestBean.ManifestHeader header = manifest.getHeader();
        String contentSize = Long.toString(header.getSourceByteSize());
        props.put("content-size", contentSize);
        props.put("content-mimetype", header.getSourceMimetype());
        props.put("content-md5", header.getSourceMD5());
        props.put("content-checksum", header.getSourceMD5());
        return props;
    }
}

