/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.util;

import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OperationTimer<T> {
    private Logger logger = LoggerFactory.getLogger(OperationTimer.class);
    private StopWatch stopWatch = new StopWatch();
    private String message = "";

    public OperationTimer(String message) {
        this.message = message;
    }

    public T execute() throws Exception {
        this.stopWatch.start();
        T result = this.executeImpl();
        this.stopWatch.stop();
        this.logger.debug("Message={} - Elapsed time: {}", (Object)this.message, (Object)this.stopWatch.toString());
        return result;
    }

    public abstract T executeImpl() throws Exception;
}

