/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.storage.aop;

import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.Session;
import org.duracloud.storage.aop.ContentCopyMessageConverter;
import org.duracloud.storage.aop.ContentMessage;
import org.duracloud.storage.aop.ContentMessageConverter;
import org.duracloud.storage.aop.IngestMessageConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;

public class AllContentEventsMessageConverter
implements MessageConverter {
    private final Logger log = LoggerFactory.getLogger(AllContentEventsMessageConverter.class);
    private ContentCopyMessageConverter copyMessageConverter = new ContentCopyMessageConverter();
    private ContentMessageConverter deleteAndUpdateConverter = new ContentMessageConverter();
    private IngestMessageConverter ingestMessageConverter = new IngestMessageConverter();

    public Object fromMessage(Message msg) throws JMSException, MessageConversionException {
        if (msg instanceof MapMessage) {
            MapMessage mapMsg = (MapMessage)msg;
            String action = mapMsg.getString("action");
            switch (ContentMessage.ACTION.valueOf(action)) {
                case COPY: {
                    return this.copyMessageConverter.fromMessage(msg);
                }
                case UPDATE: {
                    return this.deleteAndUpdateConverter.fromMessage(msg);
                }
                case DELETE: {
                    return this.deleteAndUpdateConverter.fromMessage(msg);
                }
                case INGEST: {
                    return this.ingestMessageConverter.fromMessage(msg);
                }
            }
        }
        String err = "Arg obj is not an instance of 'MapMessage': ";
        this.log.error(err + msg);
        throw new MessageConversionException(err);
    }

    public Message toMessage(Object obj, Session session) throws JMSException, MessageConversionException {
        if (obj instanceof ContentMessage) {
            ContentMessage msg = (ContentMessage)obj;
            switch (ContentMessage.ACTION.valueOf(msg.getAction())) {
                case COPY: {
                    return this.copyMessageConverter.toMessage(obj, session);
                }
                case UPDATE: {
                    return this.deleteAndUpdateConverter.toMessage(obj, session);
                }
                case DELETE: {
                    return this.deleteAndUpdateConverter.toMessage(obj, session);
                }
                case INGEST: {
                    return this.ingestMessageConverter.toMessage(obj, session);
                }
            }
        }
        String err = "Arg obj is not instance of 'ContentMessage': ";
        this.log.error(err + obj);
        throw new MessageConversionException(err);
    }
}

