/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.storage.aop;

import org.duracloud.storage.aop.ContentMessage;
import org.duracloud.storage.error.InvalidEventTSVException;

public class ContentCopyMessage
extends ContentMessage {
    private String srcSpaceId;
    private String srcContentId;

    public ContentCopyMessage() {
    }

    public ContentCopyMessage(String tsv) throws InvalidEventTSVException {
        super(tsv);
        String[] parts = tsv.split(Character.toString('\t'));
        if (parts.length < 11) {
            throw new InvalidEventTSVException(tsv);
        }
        this.setSrcSpaceId(parts[9]);
        this.setSrcContentId(parts[10]);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ContentCopyMessage[");
        sb.append("storeId:'" + this.getStoreId() + "'");
        sb.append("|sourceSpaceId:'" + this.srcSpaceId + "'");
        sb.append("|sourceContentId:'" + this.srcContentId + "'");
        sb.append("|destSpaceId:'" + this.getSpaceId() + "'");
        sb.append("|destContentId:'" + this.getContentId() + "'");
        sb.append("|username:'" + this.getUsername() + "'");
        sb.append("|contentMd5:'" + this.getContentMd5() + "'");
        sb.append("|action:'" + this.getAction() + "'");
        sb.append("|datetime:'" + this.getDatetime() + "'");
        sb.append("]\n");
        return sb.toString();
    }

    @Override
    public String asTSV() {
        StringBuilder sb = new StringBuilder(super.asTSV());
        sb.append('\t');
        sb.append("tbd");
        sb.append('\t');
        sb.append("tbd");
        sb.append('\t');
        sb.append(this.srcSpaceId);
        sb.append('\t');
        sb.append(this.srcContentId);
        return sb.toString();
    }

    public String getSrcSpaceId() {
        return this.srcSpaceId;
    }

    public void setSrcSpaceId(String srcSpaceId) {
        this.srcSpaceId = srcSpaceId;
    }

    public String getSrcContentId() {
        return this.srcContentId;
    }

    public void setSrcContentId(String srcContentId) {
        this.srcContentId = srcContentId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContentCopyMessage)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContentCopyMessage that = (ContentCopyMessage)o;
        if (this.srcContentId != null ? !this.srcContentId.equals(that.srcContentId) : that.srcContentId != null) {
            return false;
        }
        return !(this.srcSpaceId != null ? !this.srcSpaceId.equals(that.srcSpaceId) : that.srcSpaceId != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.srcSpaceId != null ? this.srcSpaceId.hashCode() : 0);
        result = 31 * result + (this.srcContentId != null ? this.srcContentId.hashCode() : 0);
        return result;
    }
}

