/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.storage.aop;

import org.duracloud.common.util.DateUtil;
import org.duracloud.storage.error.InvalidEventTSVException;

public class ContentMessage {
    private String storeId;
    private String spaceId;
    private String contentId;
    private String contentMd5;
    private String username;
    private String action;
    private String datetime = DateUtil.nowVerbose();
    protected static final char DELIM = '\t';

    public ContentMessage() {
    }

    public ContentMessage(String tsv) throws InvalidEventTSVException {
        String[] parts = tsv.split(Character.toString('\t'));
        if (parts.length < 6) {
            throw new InvalidEventTSVException(tsv);
        }
        this.setStoreId(parts[0]);
        this.setSpaceId(parts[1]);
        this.setContentId(parts[2]);
        this.setUsername(parts[3]);
        this.setAction(parts[4]);
        this.setDatetime(parts[5]);
        if (parts.length > 6) {
            this.setContentMd5(parts[6]);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ContentMessage[");
        sb.append("storeId:'" + this.storeId + "'");
        sb.append("|spaceId:'" + this.spaceId + "'");
        sb.append("|contentId:'" + this.contentId + "'");
        sb.append("|username:'" + this.username + "'");
        sb.append("|action:'" + this.action + "'");
        sb.append("|datetime:'" + this.datetime + "'");
        sb.append("]\n");
        return sb.toString();
    }

    public String asTSV() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.storeId);
        sb.append('\t');
        sb.append(this.spaceId);
        sb.append('\t');
        sb.append(this.contentId);
        sb.append('\t');
        sb.append(this.username);
        sb.append('\t');
        sb.append(this.action);
        sb.append('\t');
        sb.append(this.datetime);
        if (null != this.contentMd5) {
            sb.append('\t');
            sb.append(this.contentMd5);
        }
        return sb.toString();
    }

    public static String tsvHeader() {
        StringBuilder sb = new StringBuilder();
        sb.append("store id");
        sb.append('\t');
        sb.append("space id");
        sb.append('\t');
        sb.append("content id");
        sb.append('\t');
        sb.append("user id");
        sb.append('\t');
        sb.append("action");
        sb.append('\t');
        sb.append("datetime");
        sb.append('\t');
        sb.append("content MD5");
        sb.append('\t');
        sb.append("content size");
        sb.append('\t');
        sb.append("mimetype");
        sb.append('\t');
        sb.append("src space id");
        sb.append('\t');
        sb.append("src content id");
        return sb.toString();
    }

    public String getStoreId() {
        return this.storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public String getSpaceId() {
        return this.spaceId;
    }

    public void setSpaceId(String spaceId) {
        this.spaceId = spaceId;
    }

    public String getContentId() {
        return this.contentId;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public String getContentMd5() {
        return this.contentMd5;
    }

    public void setContentMd5(String contentMd5) {
        this.contentMd5 = contentMd5;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getDatetime() {
        return this.datetime;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContentMessage)) {
            return false;
        }
        ContentMessage that = (ContentMessage)o;
        if (this.action != null ? !this.action.equals(that.action) : that.action != null) {
            return false;
        }
        if (this.contentId != null ? !this.contentId.equals(that.contentId) : that.contentId != null) {
            return false;
        }
        if (this.datetime != null ? !this.datetime.equals(that.datetime) : that.datetime != null) {
            return false;
        }
        if (this.spaceId != null ? !this.spaceId.equals(that.spaceId) : that.spaceId != null) {
            return false;
        }
        if (this.storeId != null ? !this.storeId.equals(that.storeId) : that.storeId != null) {
            return false;
        }
        return !(this.username != null ? !this.username.equals(that.username) : that.username != null);
    }

    public int hashCode() {
        int result = this.storeId != null ? this.storeId.hashCode() : 0;
        result = 31 * result + (this.spaceId != null ? this.spaceId.hashCode() : 0);
        result = 31 * result + (this.contentId != null ? this.contentId.hashCode() : 0);
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
        result = 31 * result + (this.datetime != null ? this.datetime.hashCode() : 0);
        return result;
    }

    public static enum ACTION {
        INGEST,
        COPY,
        UPDATE,
        DELETE,
        ERROR;

    }
}

