/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.storage.aop;

import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.Session;
import org.duracloud.storage.aop.BaseContentMessageConverter;
import org.duracloud.storage.aop.ContentMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;

public class ContentMessageConverter
extends BaseContentMessageConverter
implements MessageConverter {
    protected final Logger log = LoggerFactory.getLogger(ContentMessageConverter.class);

    public Object fromMessage(Message msg) throws JMSException, MessageConversionException {
        if (!(msg instanceof MapMessage)) {
            String err = "Arg obj is not an instance of 'MapMessage': ";
            this.log.error(err + msg);
            throw new MessageConversionException(err);
        }
        MapMessage mapMsg = (MapMessage)msg;
        return super.fromMessage(new ContentMessage(), mapMsg);
    }

    public Message toMessage(Object obj, Session session) throws JMSException, MessageConversionException {
        if (!(obj instanceof ContentMessage)) {
            String err = "Arg obj is not an instance of 'ContentMessage': ";
            this.log.error(err + obj);
            throw new MessageConversionException(err);
        }
        ContentMessage contentMsg = (ContentMessage)obj;
        return super.toMessage(contentMsg, session);
    }
}

