/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.storage.aop;

import org.duracloud.storage.aop.ContentMessage;
import org.duracloud.storage.error.InvalidEventTSVException;

public class IngestMessage
extends ContentMessage {
    private String contentMimeType;
    private long contentSize;

    public IngestMessage() {
    }

    public IngestMessage(String tsv) throws InvalidEventTSVException {
        super(tsv);
        String[] parts = tsv.split(Character.toString('\t'));
        if (parts.length < 9) {
            throw new InvalidEventTSVException(tsv);
        }
        this.setContentSize(Long.parseLong(parts[7]));
        this.setContentMimeType(parts[8]);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("IngestMessage[");
        sb.append("storeId:'" + this.getStoreId() + "'");
        sb.append("|spaceId:'" + this.getSpaceId() + "'");
        sb.append("|contentId:'" + this.getContentId() + "'");
        sb.append("|mime:'" + this.contentMimeType + "'");
        sb.append("|username:'" + this.getUsername() + "'");
        sb.append("|contentMd5:'" + this.getContentMd5() + "'");
        sb.append("|contentSize:'" + this.contentSize + "'");
        sb.append("|action:'" + this.getAction() + "'");
        sb.append("|datetime:'" + this.getDatetime() + "'");
        sb.append("]\n");
        return sb.toString();
    }

    @Override
    public String asTSV() {
        StringBuilder sb = new StringBuilder(super.asTSV());
        sb.append('\t');
        sb.append(this.contentSize);
        sb.append('\t');
        sb.append(this.contentMimeType);
        return sb.toString();
    }

    public String getContentMimeType() {
        return this.contentMimeType;
    }

    public void setContentMimeType(String contentMimeType) {
        this.contentMimeType = contentMimeType;
    }

    public long getContentSize() {
        return this.contentSize;
    }

    public void setContentSize(long contentSize) {
        this.contentSize = contentSize;
    }
}

