/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.storage.domain;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.duracloud.storage.domain.StorageAccount;
import org.duracloud.storage.error.StorageException;
import org.duracloud.storage.xml.StorageAccountsDocumentBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageAccountManager {
    protected final Logger log = LoggerFactory.getLogger(StorageAccountManager.class);
    private String primaryStorageProviderId = null;
    private HashMap<String, StorageAccount> storageAccounts = null;
    private StorageAccountsDocumentBinding documentBinding = new StorageAccountsDocumentBinding();

    public void initialize(InputStream accountXml) throws StorageException {
        List<StorageAccount> accts = this.getAccounts(accountXml);
        this.storageAccounts = new HashMap();
        for (StorageAccount acct : accts) {
            this.storageAccounts.put(acct.getId(), acct);
            if (!acct.isPrimary()) continue;
            this.primaryStorageProviderId = acct.getId();
        }
        if (this.primaryStorageProviderId == null) {
            this.primaryStorageProviderId = accts.get(0).getId();
        }
        this.close(accountXml);
    }

    private List<StorageAccount> getAccounts(InputStream accountXml) {
        List<StorageAccount> accts = null;
        try {
            accts = this.documentBinding.createStorageAccountsFrom(accountXml);
        }
        catch (Exception e) {
            String error = "Unable to build storage account information due to error: " + e.getMessage();
            this.log.error(error);
            throw new StorageException(error, e);
        }
        if (null == accts || accts.isEmpty()) {
            String error = "Unable to build storage account information due to invalid input xml.";
            this.log.error(error);
            throw new StorageException(error);
        }
        return accts;
    }

    private void close(InputStream stream) {
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public StorageAccount getPrimaryStorageAccount() {
        this.checkInitialized();
        return this.getStorageAccount(this.primaryStorageProviderId);
    }

    public Iterator<String> getStorageAccountIds() {
        this.checkInitialized();
        return this.storageAccounts.keySet().iterator();
    }

    public StorageAccount getStorageAccount(String storageProviderId) {
        this.checkInitialized();
        return this.storageAccounts.get(storageProviderId);
    }

    public Map<String, StorageAccount> getStorageAccounts() {
        this.checkInitialized();
        return this.storageAccounts;
    }

    private void checkInitialized() throws StorageException {
        if (!this.isInitialized()) {
            String error = "DuraStore's StorageAccountManager must be initialized with an XML file containing storage account information before any further requests can be fulfilled.";
            throw new StorageException(error);
        }
    }

    public boolean isInitialized() throws StorageException {
        return null != this.storageAccounts && null != this.primaryStorageProviderId;
    }
}

