/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.storage.provider;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.duracloud.common.model.AclType;
import org.duracloud.storage.error.NotFoundException;
import org.duracloud.storage.error.StorageException;
import org.duracloud.storage.provider.StorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StorageProviderBase
implements StorageProvider {
    protected final Logger log = LoggerFactory.getLogger(StorageProviderBase.class);

    protected abstract boolean spaceExists(String var1);

    protected abstract void removeSpace(String var1);

    protected abstract Map<String, String> getAllSpaceProperties(String var1);

    protected abstract void doSetSpaceProperties(String var1, Map<String, String> var2);

    @Override
    public Map<String, String> getSpaceProperties(String spaceId) {
        HashMap<String, String> spaceProps = new HashMap<String, String>();
        Map<String, String> allProps = this.getAllSpaceProperties(spaceId);
        for (String name : allProps.keySet()) {
            if (name.startsWith("acl-")) continue;
            spaceProps.put(name, allProps.get(name));
        }
        return spaceProps;
    }

    @Override
    public void setSpaceProperties(String spaceId, Map<String, String> spaceProps) {
        HashMap<String, String> allProps = new HashMap<String, String>();
        Map<String, AclType> acls = this.getSpaceACLs(spaceId);
        for (String key : acls.keySet()) {
            allProps.put(key, acls.get(key).name());
        }
        if (null != spaceProps) {
            for (String key : spaceProps.keySet()) {
                if (key.startsWith("acl-")) continue;
                allProps.put(key, spaceProps.get(key));
            }
        }
        this.doSetSpaceProperties(spaceId, allProps);
    }

    protected void setNewSpaceProperties(String spaceId, Map<String, String> spaceProperties) {
        boolean success = false;
        int maxLoops = 6;
        for (int loops = 0; !success && loops < maxLoops; ++loops) {
            try {
                this.doSetSpaceProperties(spaceId, spaceProperties);
                success = true;
                continue;
            }
            catch (NotFoundException e) {
                success = false;
            }
        }
        if (!success) {
            throw new StorageException("Properties for space " + spaceId + " could not be created. " + "The space cannot be found.");
        }
    }

    @Override
    public Map<String, AclType> getSpaceACLs(String spaceId) {
        HashMap<String, AclType> acls = new HashMap<String, AclType>();
        Map<String, String> allProps = this.getAllSpaceProperties(spaceId);
        for (String name : allProps.keySet()) {
            if (!name.startsWith("acl-")) continue;
            String val = allProps.get(name);
            try {
                acls.put(name, AclType.valueOf((String)val));
            }
            catch (IllegalArgumentException e) {
                this.log.error("Invalid ACL: {}, space: {}, error: {}", new Object[]{val, spaceId, e});
            }
        }
        return acls;
    }

    @Override
    public void setSpaceACLs(String spaceId, Map<String, AclType> spaceACLs) {
        HashMap<String, String> newProps = new HashMap<String, String>();
        Map<String, String> spaceProps = this.getSpaceProperties(spaceId);
        newProps.putAll(spaceProps);
        if (null != spaceACLs) {
            for (String key : spaceACLs.keySet()) {
                if (!key.startsWith("acl-")) continue;
                AclType acl = spaceACLs.get(key);
                newProps.put(key, acl.name());
            }
        }
        this.doSetSpaceProperties(spaceId, newProps);
    }

    protected void throwIfSpaceExists(String spaceId) {
        if (this.spaceExists(spaceId)) {
            String msg = "Error: Space already exists: " + spaceId;
            throw new StorageException(msg, false);
        }
    }

    protected void throwIfSpaceNotExist(String spaceId) {
        this.throwIfSpaceNotExist(spaceId, true);
    }

    protected void throwIfSpaceNotExist(String spaceId, boolean wait) {
        if (!this.spaceExists(spaceId)) {
            String msg = "Error: Space does not exist: " + spaceId;
            if (wait) {
                this.waitForSpaceAvailable(spaceId);
                if (!this.spaceExists(spaceId)) {
                    throw new NotFoundException(msg);
                }
            } else {
                throw new NotFoundException(msg);
            }
        }
    }

    private void waitForSpaceAvailable(String spaceId) {
        int maxLoops = 6;
        for (int loops = 0; !this.spaceExists(spaceId) && loops < maxLoops; ++loops) {
            try {
                this.log.debug("Waiting for space " + spaceId + " to be available, loop " + loops);
                Thread.sleep(2000L);
                continue;
            }
            catch (InterruptedException e) {
                this.log.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void deleteSpace(String spaceId) {
        this.log.debug("deleteSpace(" + spaceId + ")");
        this.throwIfSpaceNotExist(spaceId);
        Map<String, String> allProps = this.getAllSpaceProperties(spaceId);
        allProps.put("is-delete", "true");
        this.doSetSpaceProperties(spaceId, allProps);
        SpaceDeleteWorker deleteThread = this.getSpaceDeleteWorker(spaceId);
        new Thread(deleteThread).start();
    }

    public SpaceDeleteWorker getSpaceDeleteWorker(String spaceId) {
        return new SpaceDeleteWorker(spaceId);
    }

    protected class SpaceDeleteWorker
    implements Runnable {
        protected final Logger log = LoggerFactory.getLogger(SpaceDeleteWorker.class);
        private String spaceId;

        public SpaceDeleteWorker(String spaceId) {
            this.spaceId = spaceId;
        }

        @Override
        public void run() {
            Iterator<String> contents = StorageProviderBase.this.getSpaceContents(this.spaceId, null);
            int count = 0;
            while (contents.hasNext() && count++ < 5) {
                try {
                    Thread.sleep((long)Math.pow(2.0, count) * 100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                while (contents.hasNext()) {
                    String contentId = contents.next();
                    this.log.debug("deleteContent(" + this.spaceId + ", " + contentId + ") - count=" + count);
                    try {
                        StorageProviderBase.this.deleteContent(this.spaceId, contentId);
                    }
                    catch (Exception e) {
                        this.log.error("Error deleting content " + contentId + " in space " + this.spaceId, (Throwable)e);
                    }
                }
                contents = StorageProviderBase.this.getSpaceContents(this.spaceId, null);
            }
            if (contents.hasNext()) {
                this.log.debug("deleteSpaceContents(" + this.spaceId + ") exceeded retries");
                Map<String, String> allProps = StorageProviderBase.this.getAllSpaceProperties(this.spaceId);
                allProps.put("delete-error", "Unable to delete all contents");
                StorageProviderBase.this.doSetSpaceProperties(this.spaceId, allProps);
            } else {
                this.log.debug("removeSpace(" + this.spaceId + ")");
                StorageProviderBase.this.removeSpace(this.spaceId);
            }
        }
    }
}

