/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.storage.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.duracloud.common.util.IOUtil;
import org.duracloud.common.util.SerializationUtil;
import org.duracloud.storage.error.StorageException;
import org.duracloud.storage.provider.StorageProvider;

public class StorageProviderUtil {
    public static Map<String, String> loadProperties(InputStream is) throws StorageException {
        Map propertiesMap = null;
        if (is != null) {
            try {
                String properties = IOUtil.readStringFromStream((InputStream)is);
                propertiesMap = SerializationUtil.deserializeMap((String)properties);
            }
            catch (Exception e) {
                String err = "Could not read properties  due to error: " + e.getMessage();
                throw new StorageException(err, e);
            }
        }
        if (propertiesMap == null) {
            propertiesMap = new HashMap();
        }
        return propertiesMap;
    }

    public static ByteArrayInputStream storeProperties(Map<String, String> propertiesMap) throws StorageException {
        propertiesMap.remove("space-count");
        byte[] properties = null;
        try {
            String serializedProperties = SerializationUtil.serializeMap(propertiesMap);
            properties = serializedProperties.getBytes("UTF-8");
        }
        catch (Exception e) {
            String err = "Could not store properties due to error: " + e.getMessage();
            throw new StorageException(err);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(properties);
        return is;
    }

    public static String compareChecksum(StorageProvider provider, String spaceId, String contentId, String checksum) throws StorageException {
        String providerChecksum = provider.getContentProperties(spaceId, contentId).get("content-checksum");
        return StorageProviderUtil.compareChecksum(providerChecksum, spaceId, contentId, checksum);
    }

    public static String compareChecksum(String providerChecksum, String spaceId, String contentId, String checksum) throws StorageException {
        if (!providerChecksum.equals(checksum)) {
            String err = "Content " + contentId + " was added to space " + spaceId + " but the checksum, either provided or computed " + "enroute, (" + checksum + ") does not match the checksum " + "computed by the storage provider (" + providerChecksum + "). This content should be checked or retransmitted.";
            throw new StorageException(err, false);
        }
        return providerChecksum;
    }

    public static boolean contains(Iterator<String> iterator, String value) {
        if (iterator == null || value == null) {
            return false;
        }
        while (iterator.hasNext()) {
            if (!value.equals(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public static long count(Iterator<String> iterator) {
        if (iterator == null) {
            return 0L;
        }
        long count = 0L;
        while (iterator.hasNext()) {
            ++count;
            iterator.next();
        }
        return count;
    }

    public static List<String> getList(Iterator<String> iterator) {
        ArrayList<String> contents = new ArrayList<String>();
        while (iterator.hasNext()) {
            contents.add(iterator.next());
        }
        return contents;
    }
}

