/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.storage.xml;

import java.io.InputStream;
import org.duracloud.common.util.EncryptionUtil;
import org.duracloud.storage.domain.AuditConfig;
import org.duracloud.storage.domain.DatabaseConfigXmlUtil;
import org.duracloud.storage.domain.DuraStoreInitConfig;
import org.duracloud.storage.error.StorageException;
import org.duracloud.storage.xml.StorageAccountsDocumentBinding;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuraStoreInitDocumentBinding {
    private final Logger log = LoggerFactory.getLogger(DuraStoreInitDocumentBinding.class);
    private StorageAccountsDocumentBinding accountsBinding = new StorageAccountsDocumentBinding();
    private EncryptionUtil encryptionUtil = new EncryptionUtil();

    public DuraStoreInitConfig createFromXml(InputStream xml) {
        DuraStoreInitConfig initConfig = new DuraStoreInitConfig();
        try {
            Element millDb;
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(xml);
            Element root = doc.getRootElement();
            Element accounts = root.getChild("storageProviderAccounts");
            initConfig.setStorageAccounts(this.accountsBinding.createStorageAccountsFrom(accounts));
            Element audit = root.getChild("storageAudit");
            if (null != audit) {
                String encPass;
                AuditConfig auditConfig = new AuditConfig();
                String encUser = audit.getChildText("auditUsername");
                if (null != encUser) {
                    auditConfig.setAuditUsername(this.encryptionUtil.decrypt(encUser));
                }
                if (null != (encPass = audit.getChildText("auditPassword"))) {
                    auditConfig.setAuditPassword(this.encryptionUtil.decrypt(encPass));
                }
                auditConfig.setAuditQueueName(audit.getChildText("auditQueue"));
                initConfig.setAuditConfig(auditConfig);
            }
            if (null != (millDb = root.getChild("millDb"))) {
                initConfig.setMillDbConfig(DatabaseConfigXmlUtil.unmarshalDatabaseConfig(millDb));
            }
        }
        catch (Exception e) {
            String error = "Unable to build storage account information due to error: " + e.getMessage();
            this.log.error(error);
            throw new StorageException(error, e);
        }
        return initConfig;
    }

    public String createXmlFrom(DuraStoreInitConfig duraStoreInitConfig, boolean includeCredentials, boolean includeOptions) {
        String auditQueueName;
        String auditPassword;
        String xml = "";
        Element durastoreConfig = new Element("durastoreConfig");
        Element accounts = this.accountsBinding.createDocumentFrom(duraStoreInitConfig.getStorageAccounts(), includeCredentials, includeOptions);
        durastoreConfig.addContent((Content)accounts);
        Element audit = new Element("storageAudit");
        AuditConfig auditConfig = duraStoreInitConfig.getAuditConfig();
        String auditUsername = auditConfig.getAuditUsername();
        if (null != auditUsername) {
            String username = this.encryptionUtil.encrypt(auditUsername);
            audit.addContent((Content)new Element("auditUsername").setText(username));
        }
        if (null != (auditPassword = auditConfig.getAuditPassword())) {
            String password = this.encryptionUtil.encrypt(auditPassword);
            audit.addContent((Content)new Element("auditPassword").setText(password));
        }
        if (null != (auditQueueName = auditConfig.getAuditQueueName())) {
            audit.addContent((Content)new Element("auditQueue").setText(auditQueueName));
        }
        durastoreConfig.addContent((Content)audit);
        durastoreConfig.addContent((Content)DatabaseConfigXmlUtil.marshall(duraStoreInitConfig.getMillDbConfig(), "millDb"));
        Document document = new Document(durastoreConfig);
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        return outputter.outputString(document);
    }
}

