/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.storage.provider;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.duracloud.common.model.AclType;
import org.duracloud.storage.error.NotFoundException;
import org.duracloud.storage.error.StorageException;
import org.duracloud.storage.provider.StorageProvider;
import org.duracloud.storage.util.StorageProviderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StorageProviderBase
implements StorageProvider {
    protected static final String ACL_USER_READ = "acl-user-read";
    protected static final String ACL_USER_WRITE = "acl-user-write";
    protected static final String ACL_GROUP_READ = "acl-group-read";
    protected static final String ACL_GROUP_WRITE = "acl-group-write";
    protected static final String ACL_DELIM = ":";
    protected final Logger log = LoggerFactory.getLogger(StorageProviderBase.class);
    private StorageProvider wrappedStorageProvider;

    protected abstract boolean spaceExists(String var1);

    protected abstract void removeSpace(String var1);

    protected abstract Map<String, String> getAllSpaceProperties(String var1);

    protected abstract void doSetSpaceProperties(String var1, Map<String, String> var2);

    @Override
    public Map<String, String> getSpaceProperties(String spaceId) {
        HashMap<String, String> spaceProps = new HashMap<String, String>();
        Map<String, String> allProps = this.getAllSpaceProperties(spaceId);
        for (String name : allProps.keySet()) {
            if (name.startsWith("acl-")) continue;
            spaceProps.put(name, allProps.get(name));
        }
        return spaceProps;
    }

    public void setNewSpaceProperties(String spaceId, Map<String, String> spaceProperties) {
        boolean success = false;
        int maxLoops = 6;
        for (int loops = 0; !success && loops < maxLoops; ++loops) {
            try {
                this.doSetSpaceProperties(spaceId, spaceProperties);
                success = true;
                continue;
            }
            catch (NotFoundException e) {
                success = false;
            }
        }
        if (!success) {
            throw new StorageException("Properties for space " + spaceId + " could not be created. " + "The space cannot be found.");
        }
    }

    @Override
    public Map<String, AclType> getSpaceACLs(String spaceId) {
        Map<String, String> allProps = this.getAllSpaceProperties(spaceId);
        return this.unpackACLs(allProps);
    }

    protected Map<String, AclType> unpackACLs(Map<String, String> spaceProps) {
        String writeGroupList;
        String readGroupList;
        String writeUserList;
        HashMap<String, AclType> acls = new HashMap<String, AclType>();
        String readUserList = spaceProps.get(ACL_USER_READ);
        if (null != readUserList) {
            for (String userName : readUserList.split(ACL_DELIM)) {
                acls.put("acl-" + userName, AclType.READ);
            }
        }
        if (null != (writeUserList = spaceProps.get(ACL_USER_WRITE))) {
            for (String userName : writeUserList.split(ACL_DELIM)) {
                acls.put("acl-" + userName, AclType.WRITE);
            }
        }
        if (null != (readGroupList = spaceProps.get(ACL_GROUP_READ))) {
            for (String groupName : readGroupList.split(ACL_DELIM)) {
                acls.put("acl-group-" + groupName, AclType.READ);
            }
        }
        if (null != (writeGroupList = spaceProps.get(ACL_GROUP_WRITE))) {
            for (String groupName : writeGroupList.split(ACL_DELIM)) {
                acls.put("acl-group-" + groupName, AclType.WRITE);
            }
        }
        return acls;
    }

    @Override
    public void setSpaceACLs(String spaceId, Map<String, AclType> spaceACLs) {
        HashMap<String, String> newProps = new HashMap<String, String>();
        Map<String, String> spaceProps = this.getSpaceProperties(spaceId);
        newProps.putAll(spaceProps);
        newProps.putAll(this.packACLs(spaceACLs));
        this.doSetSpaceProperties(spaceId, newProps);
    }

    protected Map<String, String> packACLs(Map<String, AclType> spaceACLs) {
        HashSet<String> readUserList = new HashSet<String>();
        HashSet<String> writeUserList = new HashSet<String>();
        HashSet<String> readGroupList = new HashSet<String>();
        HashSet<String> writeGroupList = new HashSet<String>();
        if (null != spaceACLs) {
            for (String key : spaceACLs.keySet()) {
                AclType acl = spaceACLs.get(key);
                if (key.startsWith("acl-group-")) {
                    String groupName = key.substring("acl-group-".length());
                    if (acl.equals((Object)AclType.READ)) {
                        readGroupList.add(groupName);
                        continue;
                    }
                    if (!acl.equals((Object)AclType.WRITE)) continue;
                    writeGroupList.add(groupName);
                    continue;
                }
                if (!key.startsWith("acl-")) continue;
                String userName = key.substring("acl-".length());
                if (acl.equals((Object)AclType.READ)) {
                    readUserList.add(userName);
                    continue;
                }
                if (!acl.equals((Object)AclType.WRITE)) continue;
                writeUserList.add(userName);
            }
        }
        HashMap<String, String> packedAcls = new HashMap<String, String>();
        this.includeACL(packedAcls, ACL_USER_READ, readUserList);
        this.includeACL(packedAcls, ACL_USER_WRITE, writeUserList);
        this.includeACL(packedAcls, ACL_GROUP_READ, readGroupList);
        this.includeACL(packedAcls, ACL_GROUP_WRITE, writeGroupList);
        return packedAcls;
    }

    private void includeACL(Map<String, String> packedAcls, String acl, Set<String> listEntries) {
        if (!listEntries.isEmpty()) {
            StringBuilder aclValues = new StringBuilder();
            for (String aclValue : listEntries) {
                aclValues.append(aclValue).append(ACL_DELIM);
            }
            packedAcls.put(acl, aclValues.toString());
        }
    }

    protected void throwIfSpaceExists(String spaceId) {
        if (this.spaceExists(spaceId)) {
            String msg = "Error: Space already exists: " + spaceId;
            throw new StorageException(msg, false);
        }
    }

    protected void throwIfSpaceNotExist(String spaceId) {
        this.throwIfSpaceNotExist(spaceId, true);
    }

    protected void throwIfSpaceNotExist(String spaceId, boolean wait) {
        if (!this.spaceExists(spaceId)) {
            String msg = "Error: Space does not exist: " + spaceId;
            if (wait) {
                this.waitForSpaceAvailable(spaceId);
                if (!this.spaceExists(spaceId)) {
                    throw new NotFoundException(msg);
                }
            } else {
                throw new NotFoundException(msg);
            }
        }
    }

    private void waitForSpaceAvailable(String spaceId) {
        int maxLoops = 6;
        for (int loops = 0; !this.spaceExists(spaceId) && loops < maxLoops; ++loops) {
            try {
                this.log.debug("Waiting for space " + spaceId + " to be available, loop " + loops);
                Thread.sleep(2000L);
                continue;
            }
            catch (InterruptedException e) {
                this.log.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void deleteSpace(String spaceId) {
        this.log.debug("deleteSpace(" + spaceId + ")");
        this.throwIfSpaceNotExist(spaceId);
        Map<String, String> allProps = this.getAllSpaceProperties(spaceId);
        allProps.put("is-delete", "true");
        this.doSetSpaceProperties(spaceId, allProps);
        SpaceDeleteWorker deleteThread = this.getSpaceDeleteWorker(spaceId);
        new Thread(deleteThread).start();
    }

    public void deleteSpaceSync(String spaceId) {
        this.log.debug("deleteSpaceSync(" + spaceId + ")");
        this.throwIfSpaceNotExist(spaceId);
        Map<String, String> allProps = this.getAllSpaceProperties(spaceId);
        allProps.put("is-delete", "true");
        this.doSetSpaceProperties(spaceId, allProps);
        SpaceDeleteWorker deleteWorker = this.getSpaceDeleteWorker(spaceId);
        deleteWorker.run();
    }

    public SpaceDeleteWorker getSpaceDeleteWorker(String spaceId) {
        return new SpaceDeleteWorker(spaceId);
    }

    protected Map<String, String> removeCalculatedProperties(Map<String, String> properties) {
        return StorageProviderUtil.removeCalculatedProperties(properties);
    }

    public void setWrappedStorageProvider(StorageProvider wrappedStorageProvider) {
        this.wrappedStorageProvider = wrappedStorageProvider;
    }

    protected class SpaceDeleteWorker
    implements Runnable {
        protected final Logger log = LoggerFactory.getLogger(SpaceDeleteWorker.class);
        private String spaceId;

        public SpaceDeleteWorker(String spaceId) {
            this.spaceId = spaceId;
        }

        @Override
        public void run() {
            this.log.debug("SpaceDeleteWorker started!");
            Iterator<String> contents = StorageProviderBase.this.getSpaceContents(this.spaceId, null);
            int count = 0;
            while (contents.hasNext() && count++ < 5) {
                try {
                    Thread.sleep((long)Math.pow(2.0, count) * 100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                StorageProvider sp = StorageProviderBase.this;
                if (StorageProviderBase.this.wrappedStorageProvider != null) {
                    sp = StorageProviderBase.this.wrappedStorageProvider;
                }
                while (contents.hasNext()) {
                    String contentId = contents.next();
                    this.log.debug("deleteContent(" + this.spaceId + ", " + contentId + ") - count=" + count);
                    try {
                        sp.deleteContent(this.spaceId, contentId);
                    }
                    catch (Exception e) {
                        this.log.error("Error deleting content " + contentId + " in space " + this.spaceId, (Throwable)e);
                    }
                }
                contents = StorageProviderBase.this.getSpaceContents(this.spaceId, null);
            }
            if (contents.hasNext()) {
                this.log.debug("deleteSpaceContents(" + this.spaceId + ") exceeded retries");
                Map<String, String> allProps = StorageProviderBase.this.getAllSpaceProperties(this.spaceId);
                allProps.put("delete-error", "Unable to delete all contents");
                StorageProviderBase.this.doSetSpaceProperties(this.spaceId, allProps);
            } else {
                this.log.debug("removeSpace(" + this.spaceId + ")");
                StorageProviderBase.this.removeSpace(this.spaceId);
            }
            this.log.debug("SpaceDeleteWorker ended!");
        }
    }
}

