/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.storage.provider;

import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.duracloud.common.model.AclType;
import org.duracloud.common.util.metrics.Metric;
import org.duracloud.common.util.metrics.MetricException;
import org.duracloud.common.util.metrics.MetricsProbed;
import org.duracloud.common.util.metrics.MetricsTable;
import org.duracloud.storage.domain.RetrievedContent;
import org.duracloud.storage.domain.StorageProviderType;
import org.duracloud.storage.error.StorageException;
import org.duracloud.storage.provider.StorageProvider;

public abstract class ProbedStorageProvider
implements StorageProvider,
MetricsProbed {
    protected StorageProvider storageProvider;
    protected MetricsTable metricsTable;
    protected Metric metric;

    protected abstract MetricsProbed getProbedCore();

    protected void startMetric(String methodName) {
        if (this.metric == null) {
            this.metric = new Metric(this.getClass().getName(), methodName);
            this.getMetricsTable().addMetric(this.metric);
        } else {
            this.metric.addElement(methodName);
        }
        MetricsTable subTable = new MetricsTable();
        this.metricsTable.addSubMetric(this.metric, subTable);
        MetricsProbed probed = this.getProbedCore();
        probed.setMetricsTable(subTable);
        this.metric.start(methodName);
    }

    protected void stopMetric(String methodName) {
        this.metric.stop(methodName);
    }

    public void setMetricsTable(MetricsTable metricsTable) {
        this.metricsTable = metricsTable;
        this.metric = null;
    }

    private MetricsTable getMetricsTable() {
        if (this.metricsTable == null) {
            throw new RuntimeException((Throwable)new MetricException("Metrics table has not been set."));
        }
        return this.metricsTable;
    }

    protected void setStorageProvider(StorageProvider storageProvider) {
        this.storageProvider = storageProvider;
    }

    @Override
    public StorageProviderType getStorageProviderType() {
        this.startMetric("getStorageProviderType");
        StorageProviderType type = this.storageProvider.getStorageProviderType();
        this.stopMetric("getStorageProviderType");
        return type;
    }

    @Override
    public String addContent(String spaceId, String contentId, String contentMimeType, Map<String, String> userProperties, long contentSize, String contentChecksum, InputStream content) throws StorageException {
        this.startMetric("addContent");
        String result = this.storageProvider.addContent(spaceId, contentId, contentMimeType, userProperties, contentSize, contentChecksum, content);
        this.stopMetric("addContent");
        return result;
    }

    @Override
    public String copyContent(String sourceSpaceId, String sourceContentId, String destSpaceId, String destContentId) {
        this.startMetric("copyContent");
        String result = this.storageProvider.copyContent(sourceSpaceId, sourceContentId, destSpaceId, destContentId);
        this.stopMetric("copyContent");
        return result;
    }

    @Override
    public void createSpace(String spaceId) throws StorageException {
        this.startMetric("createSpace");
        this.storageProvider.createSpace(spaceId);
        this.stopMetric("createSpace");
    }

    @Override
    public void deleteContent(String spaceId, String contentId) throws StorageException {
        this.startMetric("deleteContent");
        this.storageProvider.deleteContent(spaceId, contentId);
        this.stopMetric("deleteContent");
    }

    @Override
    public void deleteSpace(String spaceId) throws StorageException {
        this.startMetric("deleteSpace");
        this.storageProvider.deleteSpace(spaceId);
        this.stopMetric("deleteSpace");
    }

    @Override
    public RetrievedContent getContent(String spaceId, String contentId) throws StorageException {
        this.startMetric("getContent");
        RetrievedContent result = this.storageProvider.getContent(spaceId, contentId);
        this.stopMetric("getContent");
        return result;
    }

    @Override
    public RetrievedContent getContent(String spaceId, String contentId, String range) throws StorageException {
        this.startMetric("getContent");
        RetrievedContent result = this.storageProvider.getContent(spaceId, contentId, range);
        this.stopMetric("getContent");
        return result;
    }

    @Override
    public Map<String, String> getContentProperties(String spaceId, String contentId) throws StorageException {
        this.startMetric("getContentProperties");
        Map<String, String> result = this.storageProvider.getContentProperties(spaceId, contentId);
        this.stopMetric("getContentProperties");
        return result;
    }

    @Override
    public Iterator<String> getSpaceContents(String spaceId, String prefix) throws StorageException {
        this.startMetric("getSpaceContents");
        Iterator<String> result = this.storageProvider.getSpaceContents(spaceId, prefix);
        this.stopMetric("getSpaceContents");
        return result;
    }

    @Override
    public List<String> getSpaceContentsChunked(String spaceId, String prefix, long maxResults, String marker) throws StorageException {
        this.startMetric("getSpaceContents");
        List<String> result = this.storageProvider.getSpaceContentsChunked(spaceId, prefix, maxResults, marker);
        this.stopMetric("getSpaceContents");
        return result;
    }

    @Override
    public Map<String, String> getSpaceProperties(String spaceId) throws StorageException {
        this.startMetric("getSpaceProperties");
        Map<String, String> result = this.storageProvider.getSpaceProperties(spaceId);
        this.stopMetric("getSpaceProperties");
        return result;
    }

    @Override
    public Iterator<String> getSpaces() throws StorageException {
        this.startMetric("getSpaces");
        Iterator<String> result = this.storageProvider.getSpaces();
        this.stopMetric("getSpaces");
        return result;
    }

    @Override
    public void setContentProperties(String spaceId, String contentId, Map<String, String> contentProperties) throws StorageException {
        this.startMetric("setContentProperties");
        this.storageProvider.setContentProperties(spaceId, contentId, contentProperties);
        this.stopMetric("setContentProperties");
    }

    @Override
    public Map<String, AclType> getSpaceACLs(String spaceId) {
        this.startMetric("getSpaceACLs");
        Map<String, AclType> result = this.storageProvider.getSpaceACLs(spaceId);
        this.stopMetric("getSpaceACLs");
        return result;
    }

    @Override
    public void setSpaceACLs(String spaceId, Map<String, AclType> spaceACLs) {
        this.startMetric("setSpaceACLs");
        this.storageProvider.setSpaceACLs(spaceId, spaceACLs);
        this.stopMetric("setSpaceACLs");
    }
}

