/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.client;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.duracloud.client.ContentStore;
import org.duracloud.error.ContentStoreException;

public class ContentIterator
implements Iterator<String> {
    private ContentStore store;
    private String spaceId;
    private String prefix;
    private int index = 0;
    private List<String> contentList;
    private long maxResults;

    public ContentIterator(ContentStore store, String spaceId, String prefix) throws ContentStoreException {
        this(store, spaceId, prefix, 1000L);
    }

    public ContentIterator(ContentStore store, String spaceId, String prefix, long maxResults) throws ContentStoreException {
        this.store = store;
        this.spaceId = spaceId;
        this.prefix = prefix;
        this.maxResults = maxResults;
        this.contentList = this.buildContentList(null);
    }

    @Override
    public boolean hasNext() {
        if (this.index < this.contentList.size()) {
            return true;
        }
        if (this.contentList.size() > 0) {
            this.updateList();
            return this.contentList.size() > 0;
        }
        return false;
    }

    @Override
    public String next() {
        if (this.hasNext()) {
            String next = this.contentList.get(this.index);
            ++this.index;
            return next;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void updateList() {
        String lastItem = this.contentList.get(this.contentList.size() - 1);
        try {
            this.contentList = this.buildContentList(lastItem);
        }
        catch (ContentStoreException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
        this.index = 0;
    }

    private List<String> buildContentList(String lastItem) throws ContentStoreException {
        return this.store.getSpace(this.spaceId, this.prefix, this.maxResults, lastItem).getContentIds();
    }
}

