/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.client;

import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.duracloud.common.model.AclType;
import org.duracloud.domain.Content;
import org.duracloud.domain.Space;
import org.duracloud.error.ContentStoreException;
import org.duracloud.error.InvalidIdException;

public interface ContentStore {
    public static final String SPACE_CREATED = "space-created";
    public static final String SPACE_COUNT = "space-count";
    public static final String SPACE_SIZE = "space-total-size";
    public static final String CONTENT_MIMETYPE = "content-mimetype";
    public static final String CONTENT_SIZE = "content-size";
    public static final String CONTENT_CHECKSUM = "content-checksum";
    public static final String CONTENT_MODIFIED = "content-modified";

    public String getBaseURL();

    public String getStoreId();

    public String getStorageProviderType();

    public List<String> getSpaces() throws ContentStoreException;

    public Iterator<String> getSpaceContents(String var1) throws ContentStoreException;

    public Iterator<String> getSpaceContents(String var1, String var2) throws ContentStoreException;

    public Space getSpace(String var1, String var2, long var3, String var5) throws ContentStoreException;

    public void createSpace(String var1, Map<String, String> var2) throws ContentStoreException;

    public void deleteSpace(String var1) throws ContentStoreException;

    public Map<String, String> getSpaceProperties(String var1) throws ContentStoreException;

    public void setSpaceProperties(String var1, Map<String, String> var2) throws ContentStoreException;

    public Map<String, AclType> getSpaceACLs(String var1) throws ContentStoreException;

    public void setSpaceACLs(String var1, Map<String, AclType> var2) throws ContentStoreException;

    public String addContent(String var1, String var2, InputStream var3, long var4, String var6, String var7, Map<String, String> var8) throws ContentStoreException;

    public String copyContent(String var1, String var2, String var3, String var4) throws ContentStoreException;

    public String copyContent(String var1, String var2, String var3, String var4, String var5) throws ContentStoreException;

    public String moveContent(String var1, String var2, String var3, String var4) throws ContentStoreException;

    public String moveContent(String var1, String var2, String var3, String var4, String var5) throws ContentStoreException;

    public Content getContent(String var1, String var2) throws ContentStoreException;

    public void deleteContent(String var1, String var2) throws ContentStoreException;

    public void setContentProperties(String var1, String var2, Map<String, String> var3) throws ContentStoreException;

    public Map<String, String> getContentProperties(String var1, String var2) throws ContentStoreException;

    public void validateSpaceId(String var1) throws InvalidIdException;

    public void validateContentId(String var1) throws InvalidIdException;

    public List<String> getSupportedTasks() throws ContentStoreException;

    public String performTask(String var1, String var2) throws ContentStoreException;
}

