/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.duracloud.client.ContentIterator;
import org.duracloud.client.ContentStore;
import org.duracloud.common.model.AclType;
import org.duracloud.common.util.SerializationUtil;
import org.duracloud.common.web.EncodeUtil;
import org.duracloud.common.web.RestHttpHelper;
import org.duracloud.domain.Content;
import org.duracloud.domain.Space;
import org.duracloud.error.ContentStoreException;
import org.duracloud.error.NotFoundException;
import org.duracloud.error.UnauthorizedException;
import org.duracloud.error.UnsupportedTaskException;
import org.duracloud.storage.domain.StorageProviderType;
import org.duracloud.storage.error.InvalidIdException;
import org.duracloud.storage.util.IdUtil;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class ContentStoreImpl
implements ContentStore {
    private String storeId = null;
    private StorageProviderType type = null;
    private String baseURL = null;
    private RestHttpHelper restHelper;
    private static final String HEADER_PREFIX = "x-dura-meta-";

    public ContentStoreImpl(String baseURL, StorageProviderType type, String storeId, RestHttpHelper restHelper) {
        this.baseURL = baseURL;
        this.type = type;
        this.storeId = storeId;
        this.restHelper = restHelper;
    }

    @Override
    public String getBaseURL() {
        return this.baseURL;
    }

    @Override
    public String getStoreId() {
        return this.storeId;
    }

    @Override
    public String getStorageProviderType() {
        return this.type.name();
    }

    private String addStoreIdQueryParameter(String url) {
        return this.addStoreIdQueryParameter(url, this.storeId);
    }

    private String addStoreIdQueryParameter(String url, String storeId) {
        return this.addQueryParameter(url, "storeID", storeId);
    }

    private String buildURL(String relativeURL) {
        String url = this.baseURL + relativeURL;
        return url;
    }

    private String buildSpaceURL(String spaceId) {
        String url = this.buildURL("/" + spaceId);
        return this.addStoreIdQueryParameter(url);
    }

    private String buildContentURL(String spaceId, String contentId) {
        return this.buildContentURL(this.storeId, spaceId, contentId);
    }

    private String buildContentURL(String storeId, String spaceId, String contentId) {
        contentId = EncodeUtil.urlEncode((String)contentId);
        String url = this.buildURL("/" + spaceId + "/" + contentId);
        return this.addStoreIdQueryParameter(url, storeId);
    }

    private String buildAclURL(String spaceId) {
        String url = this.buildURL("/acl/" + spaceId);
        return this.addStoreIdQueryParameter(url);
    }

    private String buildTaskURL() {
        String url = this.buildURL("/task");
        return this.addStoreIdQueryParameter(url);
    }

    private String buildTaskURL(String taskName) {
        String url = this.buildURL("/task/" + taskName);
        return this.addStoreIdQueryParameter(url);
    }

    private String buildSpaceURL(String spaceId, String prefix, long maxResults, String marker) {
        String url = this.buildURL("/" + spaceId);
        url = this.addQueryParameter(url, "prefix", prefix);
        String max = null;
        if (maxResults > 0L) {
            max = String.valueOf(maxResults);
        }
        url = this.addQueryParameter(url, "maxResults", max);
        url = this.addQueryParameter(url, "marker", marker);
        return this.addStoreIdQueryParameter(url);
    }

    private String addQueryParameter(String url, String name, String value) {
        if (value != null && !value.equals("")) {
            url = url.contains("?") ? url + "&" : url + "?";
            url = url + name + "=" + EncodeUtil.urlEncode((String)value);
        }
        return url;
    }

    @Override
    public List<String> getSpaces() throws ContentStoreException {
        String task = "get spaces";
        String url = this.buildURL("/spaces");
        url = this.addStoreIdQueryParameter(url);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.get(url);
            this.checkResponse(response, 200);
            String responseText = response.getResponseBody();
            if (responseText != null) {
                ArrayList<String> spaceIds = new ArrayList<String>();
                ByteArrayInputStream is = new ByteArrayInputStream(responseText.getBytes("UTF-8"));
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build((InputStream)is);
                Element spacesElem = doc.getRootElement();
                for (Element spaceElem : spacesElem.getChildren()) {
                    spaceIds.add(spaceElem.getAttributeValue("id"));
                }
                return spaceIds;
            }
            throw new ContentStoreException("Response body is empty");
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(task, "listing", (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException("Error attempting to get spaces due to: " + e.getMessage(), e);
        }
    }

    @Override
    public Iterator<String> getSpaceContents(String spaceId) throws ContentStoreException {
        return this.getSpaceContents(spaceId, null);
    }

    @Override
    public Iterator<String> getSpaceContents(String spaceId, String prefix) throws ContentStoreException {
        return new ContentIterator(this, spaceId, prefix);
    }

    @Override
    public Space getSpace(String spaceId, String prefix, long maxResults, String marker) throws ContentStoreException {
        String task = "get space";
        String url = this.buildSpaceURL(spaceId, prefix, maxResults, marker);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.get(url);
            this.checkResponse(response, 200);
            Space space = new Space();
            space.setProperties(this.extractPropertiesFromHeaders(response));
            String responseText = response.getResponseBody();
            if (responseText != null) {
                ByteArrayInputStream is = new ByteArrayInputStream(responseText.getBytes("UTF-8"));
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build((InputStream)is);
                Element spaceElem = doc.getRootElement();
                space.setId(spaceElem.getAttributeValue("id"));
                for (Element contentElem : spaceElem.getChildren()) {
                    space.addContentId(contentElem.getText());
                }
            } else {
                throw new ContentStoreException("Response body is empty");
            }
            return space;
        }
        catch (NotFoundException e) {
            throw new NotFoundException(task, spaceId, (Exception)((Object)e));
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(task, spaceId, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException(task, spaceId, e);
        }
    }

    @Override
    public void createSpace(String spaceId, Map<String, String> spaceProperties) throws ContentStoreException {
        this.validateSpaceId(spaceId);
        String task = "create space";
        String url = this.buildSpaceURL(spaceId);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.put(url, null, this.convertPropertiesToHeaders(spaceProperties));
            this.checkResponse(response, 201);
        }
        catch (org.duracloud.error.InvalidIdException e) {
            throw new org.duracloud.error.InvalidIdException(task, spaceId, (Exception)((Object)e));
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(task, spaceId, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException(task, spaceId, e);
        }
    }

    @Override
    public void deleteSpace(String spaceId) throws ContentStoreException {
        String task = "delete space";
        String url = this.buildSpaceURL(spaceId);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.delete(url);
            this.checkResponse(response, 200);
        }
        catch (NotFoundException e) {
            throw new NotFoundException(task, spaceId, (Exception)((Object)e));
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(task, spaceId, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException(task, spaceId, e);
        }
    }

    @Override
    public Map<String, String> getSpaceProperties(String spaceId) throws ContentStoreException {
        String task = "get space properties";
        String url = this.buildSpaceURL(spaceId);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.head(url);
            this.checkResponse(response, 200);
            return this.extractPropertiesFromHeaders(response);
        }
        catch (NotFoundException e) {
            throw new NotFoundException(task, spaceId, (Exception)((Object)e));
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(task, spaceId, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException(task, spaceId, e);
        }
    }

    @Override
    public void setSpaceProperties(String spaceId, Map<String, String> spaceProperties) throws ContentStoreException {
        String task = "set space properties";
        String url = this.buildSpaceURL(spaceId);
        Map<String, String> headers = this.convertPropertiesToHeaders(spaceProperties);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.post(url, null, headers);
            this.checkResponse(response, 200);
        }
        catch (NotFoundException e) {
            throw new NotFoundException(task, spaceId, (Exception)((Object)e));
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(task, spaceId, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException(task, spaceId, e);
        }
    }

    @Override
    public Map<String, AclType> getSpaceACLs(String spaceId) throws ContentStoreException {
        String task = "get space ACLs";
        String url = this.buildAclURL(spaceId);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.head(url);
            this.checkResponse(response, 200);
            return this.doGetSpaceACLs(response);
        }
        catch (NotFoundException e) {
            throw new NotFoundException(task, spaceId, (Exception)((Object)e));
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(task, spaceId, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException(task, spaceId, e);
        }
    }

    private Map<String, AclType> doGetSpaceACLs(RestHttpHelper.HttpResponse response) {
        HashMap<String, AclType> acls = new HashMap<String, AclType>();
        Map<String, String> aclProps = this.extractPropertiesFromHeaders(response, "acl-");
        for (String key : aclProps.keySet()) {
            String val = aclProps.get(key);
            acls.put(key, AclType.valueOf((String)val));
        }
        return acls;
    }

    @Override
    public void setSpaceACLs(String spaceId, Map<String, AclType> spaceACLs) throws ContentStoreException {
        String task = "set space ACLs";
        String url = this.buildAclURL(spaceId);
        Map<String, String> headers = this.convertAclsToHeaders(spaceACLs);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.post(url, null, headers);
            this.checkResponse(response, 200);
        }
        catch (NotFoundException e) {
            throw new NotFoundException(task, spaceId, (Exception)((Object)e));
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(task, spaceId, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException(task, spaceId, e);
        }
    }

    private Map<String, String> convertAclsToHeaders(Map<String, AclType> acls) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (acls != null) {
            for (String key : acls.keySet()) {
                AclType acl = acls.get(key);
                headers.put("x-dura-meta-acl-" + key, acl.name());
            }
        }
        return headers;
    }

    @Override
    public String addContent(String spaceId, String contentId, InputStream content, long contentSize, String contentMimeType, String contentChecksum, Map<String, String> contentProperties) throws ContentStoreException {
        this.validateContentId(contentId);
        String task = "add content";
        String url = this.buildContentURL(spaceId, contentId);
        if (contentMimeType != null && !contentMimeType.equals("")) {
            if (contentProperties == null) {
                contentProperties = new HashMap<String, String>();
            }
            contentProperties.put("content-mimetype", contentMimeType);
        }
        Map<String, String> headers = this.convertPropertiesToHeaders(contentProperties);
        if (contentChecksum != null) {
            headers.put("Content-MD5", contentChecksum);
        }
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.put(url, content, String.valueOf(contentSize), contentMimeType, headers);
            this.checkResponse(response, 201);
            Header checksum = response.getResponseHeader("Content-MD5");
            if (checksum == null) {
                checksum = response.getResponseHeader("ETag");
            }
            return checksum.getValue();
        }
        catch (org.duracloud.error.InvalidIdException e) {
            throw new org.duracloud.error.InvalidIdException(task, spaceId, contentId, (Exception)((Object)e));
        }
        catch (NotFoundException e) {
            throw new NotFoundException(task, spaceId, contentId, (Exception)((Object)e));
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(task, spaceId, contentId, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException(task, spaceId, contentId, e);
        }
    }

    @Override
    public String copyContent(String srcSpaceId, String srcContentId, String destStoreId, String destSpaceId, String destContentId) throws ContentStoreException {
        this.validateStoreId(destStoreId);
        this.validateSpaceId(srcSpaceId);
        this.validateSpaceId(destSpaceId);
        this.validateContentId(srcContentId);
        this.validateContentId(destContentId);
        String task = "copy content";
        srcContentId = EncodeUtil.urlEncode((String)srcContentId);
        String url = this.buildContentURL(destStoreId, destSpaceId, destContentId);
        HashMap<String, String> headers = new HashMap<String, String>();
        String sourceHeader = "x-dura-meta-copy-source";
        String sourceValue = srcSpaceId + "/" + srcContentId;
        headers.put(sourceHeader, sourceValue);
        String storeHeader = "x-dura-meta-copy-source-store";
        headers.put(storeHeader, this.storeId);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.put(url, null, headers);
            this.checkResponse(response, 201);
            Header checksum = response.getResponseHeader("Content-MD5");
            if (checksum == null) {
                checksum = response.getResponseHeader("ETag");
            }
            return checksum.getValue();
        }
        catch (org.duracloud.error.InvalidIdException e) {
            throw new org.duracloud.error.InvalidIdException(task, srcSpaceId, srcContentId, destSpaceId, destContentId, (Exception)((Object)e));
        }
        catch (NotFoundException e) {
            throw new NotFoundException(task, srcSpaceId, srcContentId, destSpaceId, destContentId, (Exception)((Object)e));
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(task, srcSpaceId, srcContentId, destSpaceId, destContentId, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException(task, srcSpaceId, srcContentId, destSpaceId, destContentId, e);
        }
    }

    @Override
    public String copyContent(String srcSpaceId, String srcContentId, String destSpaceId, String destContentId) throws ContentStoreException {
        return this.copyContent(srcSpaceId, srcContentId, this.getStoreId(), destSpaceId, destContentId);
    }

    @Override
    public String moveContent(String srcSpaceId, String srcContentId, String destSpaceId, String destContentId) throws ContentStoreException {
        return this.moveContent(srcSpaceId, srcContentId, this.getStoreId(), destSpaceId, destContentId);
    }

    @Override
    public String moveContent(String srcSpaceId, String srcContentId, String destStoreId, String destSpaceId, String destContentId) throws ContentStoreException {
        String md5 = this.copyContent(srcSpaceId, srcContentId, destStoreId, destSpaceId, destContentId);
        this.deleteContent(srcSpaceId, srcContentId);
        return md5;
    }

    @Override
    public Content getContent(String spaceId, String contentId) throws ContentStoreException {
        String task = "get content";
        String url = this.buildContentURL(spaceId, contentId);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.get(url);
            this.checkResponse(response, 200);
            Content content = new Content();
            content.setId(contentId);
            content.setStream(response.getResponseStream());
            content.setProperties(this.mergeMaps(this.extractPropertiesFromHeaders(response), this.extractNonPropertiesHeaders(response)));
            return content;
        }
        catch (NotFoundException e) {
            throw new NotFoundException(task, spaceId, contentId, (Exception)((Object)e));
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(task, spaceId, contentId, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException(task, spaceId, contentId, e);
        }
    }

    @Override
    public void deleteContent(String spaceId, String contentId) throws ContentStoreException {
        String task = "delete content";
        String url = this.buildContentURL(spaceId, contentId);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.delete(url);
            this.checkResponse(response, 200);
        }
        catch (NotFoundException e) {
            throw new NotFoundException(task, spaceId, contentId, (Exception)((Object)e));
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(task, spaceId, contentId, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException(task, spaceId, contentId, e);
        }
    }

    @Override
    public void setContentProperties(String spaceId, String contentId, Map<String, String> contentProperties) throws ContentStoreException {
        String task = "update content properties";
        String url = this.buildContentURL(spaceId, contentId);
        Map<String, String> headers = this.convertPropertiesToHeaders(contentProperties);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.post(url, null, headers);
            this.checkResponse(response, 200);
        }
        catch (NotFoundException e) {
            throw new NotFoundException(task, spaceId, contentId, (Exception)((Object)e));
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(task, spaceId, contentId, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException(task, spaceId, contentId, e);
        }
    }

    @Override
    public Map<String, String> getContentProperties(String spaceId, String contentId) throws ContentStoreException {
        String task = "get properties";
        String url = this.buildContentURL(spaceId, contentId);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.head(url);
            this.checkResponse(response, 200);
            return this.mergeMaps(this.extractPropertiesFromHeaders(response), this.extractNonPropertiesHeaders(response));
        }
        catch (NotFoundException e) {
            throw new NotFoundException(task, spaceId, contentId, (Exception)((Object)e));
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(task, spaceId, contentId, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException(task, spaceId, contentId, e);
        }
    }

    private void checkResponse(RestHttpHelper.HttpResponse response, int expectedCode) throws ContentStoreException {
        if (response == null) {
            throw new ContentStoreException("Response content was null.");
        }
        int responseCode = response.getStatusCode();
        if (responseCode != expectedCode) {
            String errMsg = "Response code was " + responseCode + ", expected value was " + expectedCode + ". ";
            try {
                String responseBody = response.getResponseBody();
                errMsg = errMsg + "Response body value: " + responseBody;
            }
            catch (IOException e) {
                // empty catch block
            }
            if (responseCode == 404) {
                throw new NotFoundException(errMsg);
            }
            if (responseCode == 400) {
                throw new org.duracloud.error.InvalidIdException(errMsg);
            }
            if (responseCode == 401) {
                throw new UnauthorizedException(errMsg);
            }
            if (responseCode == 403) {
                throw new UnauthorizedException("User is not authorized to perform the requested function");
            }
            throw new ContentStoreException(errMsg);
        }
    }

    private Map<String, String> convertPropertiesToHeaders(Map<String, String> properties) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (properties != null) {
            for (String key : properties.keySet()) {
                headers.put(HEADER_PREFIX + key, properties.get(key));
            }
        }
        return headers;
    }

    private Map<String, String> extractPropertiesFromHeaders(RestHttpHelper.HttpResponse response) {
        return this.extractPropertiesFromHeaders(response, null);
    }

    private Map<String, String> extractPropertiesFromHeaders(RestHttpHelper.HttpResponse response, String keyPrefix) {
        HashMap<String, String> properties = new HashMap<String, String>();
        String prefix = HEADER_PREFIX + (keyPrefix != null ? keyPrefix : "");
        for (Header header : response.getResponseHeaders()) {
            String name = header.getName();
            if (!name.startsWith(prefix)) continue;
            properties.put(name.substring(prefix.length()), header.getValue());
        }
        return properties;
    }

    private Map<String, String> extractNonPropertiesHeaders(RestHttpHelper.HttpResponse response) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Header header : response.getResponseHeaders()) {
            String name = header.getName();
            if (name.startsWith(HEADER_PREFIX)) continue;
            if (name.equals("Content-Type")) {
                headers.put("content-mimetype", header.getValue());
                continue;
            }
            if (name.equals("Content-MD5") || name.equals("ETag")) {
                headers.put("content-checksum", header.getValue());
                continue;
            }
            if (name.equals("Content-Length")) {
                headers.put("content-size", header.getValue());
                continue;
            }
            if (!name.equals("Last-Modified")) continue;
            headers.put("content-modified", header.getValue());
        }
        return headers;
    }

    private Map<String, String> mergeMaps(Map<String, String> map1, Map<String, String> map2) {
        for (String name : map1.keySet()) {
            map2.put(name, map1.get(name));
        }
        return map2;
    }

    public void validateStoreId(String storeId) throws org.duracloud.error.InvalidIdException {
        try {
            IdUtil.validateStoreId((String)storeId);
        }
        catch (InvalidIdException e) {
            throw new org.duracloud.error.InvalidIdException(e.getMessage());
        }
    }

    @Override
    public void validateSpaceId(String spaceId) throws org.duracloud.error.InvalidIdException {
        try {
            IdUtil.validateSpaceId((String)spaceId);
        }
        catch (InvalidIdException e) {
            throw new org.duracloud.error.InvalidIdException(e.getMessage());
        }
    }

    @Override
    public void validateContentId(String contentId) throws org.duracloud.error.InvalidIdException {
        try {
            IdUtil.validateContentId((String)contentId);
        }
        catch (InvalidIdException e) {
            throw new org.duracloud.error.InvalidIdException(e.getMessage());
        }
    }

    @Override
    public List<String> getSupportedTasks() throws ContentStoreException {
        String url = this.buildTaskURL();
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.get(url);
            this.checkResponse(response, 200);
            String reponseText = response.getResponseBody();
            return SerializationUtil.deserializeList((String)reponseText);
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException("Not authorized to get supported tasks", (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException("Error getting supported tasks: " + e.getMessage(), e);
        }
    }

    @Override
    public String performTask(String taskName, String taskParameters) throws ContentStoreException {
        String url = this.buildTaskURL(taskName);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.post(url, taskParameters, null);
            this.checkResponse(response, 200);
            return response.getResponseBody();
        }
        catch (org.duracloud.error.InvalidIdException e) {
            throw new UnsupportedTaskException(taskName, (Throwable)((Object)e));
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException("Not authorized to perform task: " + taskName, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException("Error performing task: " + taskName + e.getMessage(), e);
        }
    }
}

