/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.client;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.duracloud.client.ContentStore;
import org.duracloud.client.ContentStoreImpl;
import org.duracloud.client.ContentStoreManager;
import org.duracloud.common.model.Credential;
import org.duracloud.common.model.Securable;
import org.duracloud.common.web.RestHttpHelper;
import org.duracloud.error.ContentStoreException;
import org.duracloud.storage.domain.StorageAccount;
import org.duracloud.storage.domain.StorageAccountManager;
import org.duracloud.storage.domain.StorageProviderType;
import org.duracloud.storage.error.StorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentStoreManagerImpl
implements ContentStoreManager,
Securable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String DEFAULT_CONTEXT = "durastore";
    private String baseURL = null;
    private RestHttpHelper restHelper;

    public ContentStoreManagerImpl(String host, String port) {
        this(host, port, DEFAULT_CONTEXT);
    }

    public ContentStoreManagerImpl(String host, String port, String context) {
        this.init(host, port, context);
    }

    private void init(String host, String port, String context) {
        if (host == null || host.equals("")) {
            throw new IllegalArgumentException("Host must be a valid server host name");
        }
        if (context == null) {
            context = DEFAULT_CONTEXT;
        }
        this.baseURL = port == null || port.equals("") ? "http://" + host + "/" + context : (port.equals("443") ? "https://" + host + "/" + context : "http://" + host + ":" + port + "/" + context);
    }

    @Override
    public void reinitialize(String host, String port, String context) throws ContentStoreException {
        this.init(host, port, context);
    }

    @Override
    public Map<String, ContentStore> getContentStores() throws ContentStoreException {
        this.log.debug("getContentStores()");
        StorageAccountManager acctManager = this.getStorageAccounts();
        Map accounts = acctManager.getStorageAccounts();
        HashMap<String, ContentStore> contentStores = new HashMap<String, ContentStore>();
        for (String acctID : accounts.keySet()) {
            StorageAccount acct = (StorageAccount)accounts.get(acctID);
            contentStores.put(acctID, this.newContentStoreImpl(acct));
        }
        return contentStores;
    }

    @Override
    public ContentStore getContentStore(String storeID) throws ContentStoreException {
        StorageAccountManager acctManager = this.getStorageAccounts();
        StorageAccount acct = acctManager.getStorageAccount(storeID);
        return this.newContentStoreImpl(acct);
    }

    @Override
    public ContentStore getPrimaryContentStore() throws ContentStoreException {
        StorageAccountManager acctManager = this.getStorageAccounts();
        StorageAccount acct = acctManager.getPrimaryStorageAccount();
        return this.newContentStoreImpl(acct);
    }

    @Override
    public ContentStore getPrimaryContentStoreAsAnonymous() throws ContentStoreException {
        return this.newAnonymousContentStoreImpl();
    }

    public void login(Credential appCred) {
        this.log.debug("login: " + appCred.getUsername());
        this.setRestHelper(new RestHttpHelper(appCred));
    }

    public void logout() {
        this.log.debug("logout");
        this.setRestHelper(new RestHttpHelper());
    }

    private StorageAccountManager getStorageAccounts() throws ContentStoreException {
        String url = this.baseURL + "/stores";
        String error = "Error retrieving content stores. ";
        try {
            RestHttpHelper.HttpResponse response = this.getRestHelper().get(url);
            if (response.getStatusCode() == 200) {
                String storesXML = response.getResponseBody();
                if (storesXML != null) {
                    ByteArrayInputStream is = new ByteArrayInputStream(storesXML.getBytes());
                    StorageAccountManager storageAccountManager = new StorageAccountManager();
                    storageAccountManager.initialize((InputStream)is);
                    return storageAccountManager;
                }
                throw new StorageException(error + "Response content was null");
            }
            error = error + "Response code was " + response.getStatusCode() + ", expected value was " + 200 + ". Response Body: " + response.getResponseBody();
            throw new StorageException(error);
        }
        catch (Exception e) {
            throw new ContentStoreException(error + e.getMessage(), e);
        }
    }

    protected ContentStore newContentStoreImpl(StorageAccount acct) {
        return new ContentStoreImpl(this.baseURL, acct.getType(), acct.getId(), this.getRestHelper());
    }

    private ContentStore newAnonymousContentStoreImpl() {
        return new ContentStoreImpl(this.baseURL, StorageProviderType.UNKNOWN, null, this.getRestHelper());
    }

    protected String getBaseURL() {
        return this.baseURL;
    }

    protected RestHttpHelper getRestHelper() {
        if (null == this.restHelper) {
            this.restHelper = new RestHttpHelper();
        }
        return this.restHelper;
    }

    protected void setRestHelper(RestHttpHelper restHelper) {
        this.restHelper = restHelper;
    }
}

