/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.http.Header;
import org.duracloud.client.ContentIterator;
import org.duracloud.client.ContentStore;
import org.duracloud.client.SpaceStatsDTOList;
import org.duracloud.common.constant.ManifestFormat;
import org.duracloud.common.json.JaxbJsonSerializer;
import org.duracloud.common.model.AclType;
import org.duracloud.common.retry.ExceptionHandler;
import org.duracloud.common.retry.Retriable;
import org.duracloud.common.retry.Retrier;
import org.duracloud.common.util.DateUtil;
import org.duracloud.common.util.SerializationUtil;
import org.duracloud.common.web.EncodeUtil;
import org.duracloud.common.web.RestHttpHelper;
import org.duracloud.domain.Content;
import org.duracloud.domain.Space;
import org.duracloud.error.ContentStateException;
import org.duracloud.error.ContentStoreException;
import org.duracloud.error.InvalidIdException;
import org.duracloud.error.NotFoundException;
import org.duracloud.error.NotImplementedException;
import org.duracloud.error.UnauthorizedException;
import org.duracloud.error.UnsupportedTaskException;
import org.duracloud.reportdata.bitintegrity.BitIntegrityReport;
import org.duracloud.reportdata.bitintegrity.BitIntegrityReportProperties;
import org.duracloud.reportdata.bitintegrity.BitIntegrityReportResult;
import org.duracloud.storage.domain.StorageProviderType;
import org.duracloud.storage.error.ChecksumMismatchException;
import org.duracloud.storage.util.IdUtil;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentStoreImpl
implements ContentStore {
    private String storeId = null;
    private StorageProviderType type = null;
    private String baseURL = null;
    private RestHttpHelper restHelper;
    private static final String HEADER_PREFIX = "x-dura-meta-";
    private int maxRetries = 3;
    private final Logger log = LoggerFactory.getLogger(ContentStoreImpl.class);
    private ExceptionHandler retryExceptionHandler;
    private String clientVersion;

    public ContentStoreImpl(String baseURL, StorageProviderType type, String storeId, RestHttpHelper restHelper) {
        this.baseURL = baseURL;
        this.type = type;
        this.storeId = storeId;
        this.restHelper = restHelper;
        this.retryExceptionHandler = new ExceptionHandler(){

            public void handle(Exception ex) {
                if (!(ex instanceof NotFoundException)) {
                    ContentStoreImpl.this.log.warn(ex.getMessage());
                } else {
                    ContentStoreImpl.this.log.debug(ex.getMessage());
                }
            }
        };
        this.clientVersion = ResourceBundle.getBundle("storeclient").getString("version");
    }

    public ContentStoreImpl(String baseURL, StorageProviderType type, String storeId, RestHttpHelper restHelper, int maxRetries) {
        this(baseURL, type, storeId, restHelper);
        if (maxRetries >= 0) {
            this.maxRetries = maxRetries;
        }
    }

    @Override
    public void setRetryExceptionHandler(ExceptionHandler retryExceptionHandler) {
        this.retryExceptionHandler = retryExceptionHandler;
    }

    @Override
    public String getBaseURL() {
        return this.baseURL;
    }

    @Override
    public String getStoreId() {
        return this.storeId;
    }

    @Override
    public String getStorageProviderType() {
        return this.type.name();
    }

    private String addStoreIdQueryParameter(String url) {
        return this.addStoreIdQueryParameter(url, this.storeId);
    }

    private String addStoreIdQueryParameter(String url, String storeId) {
        return this.addQueryParameter(url, "storeID", storeId);
    }

    private String buildURL(String relativeURL) {
        String url = this.baseURL + relativeURL;
        return url;
    }

    private String buildSpaceURL(String spaceId) {
        String url = this.buildURL("/" + spaceId);
        return this.addStoreIdQueryParameter(url);
    }

    private String buildContentURL(String spaceId, String contentId) {
        return this.buildContentURL(this.storeId, spaceId, contentId);
    }

    private String buildContentURL(String storeId, String spaceId, String contentId) {
        contentId = EncodeUtil.urlEncode((String)contentId);
        String url = this.buildURL("/" + spaceId + "/" + contentId);
        return this.addStoreIdQueryParameter(url, storeId);
    }

    private String buildAclURL(String spaceId) {
        String url = this.buildURL("/acl/" + spaceId);
        return this.addStoreIdQueryParameter(url);
    }

    private String buildTaskURL() {
        String url = this.buildURL("/task");
        return this.addStoreIdQueryParameter(url);
    }

    private String buildTaskURL(String taskName) {
        String url = this.buildURL("/task/" + taskName);
        return this.addStoreIdQueryParameter(url);
    }

    private String buildSpaceURL(String spaceId, String prefix, long maxResults, String marker) {
        String url = this.buildURL("/" + spaceId);
        url = this.addQueryParameter(url, "prefix", prefix);
        String max = null;
        if (maxResults > 0L) {
            max = String.valueOf(maxResults);
        }
        url = this.addQueryParameter(url, "maxResults", max);
        url = this.addQueryParameter(url, "marker", marker);
        return this.addStoreIdQueryParameter(url);
    }

    private String addQueryParameter(String url, String name, String value) {
        if (value != null && !value.equals("")) {
            url = url.contains("?") ? url + "&" : url + "?";
            url = url + name + "=" + EncodeUtil.urlEncode((String)value);
        }
        return url;
    }

    protected <T> T execute(Retriable retriable) throws ContentStoreException {
        try {
            Retrier retrier = new Retrier(this.maxRetries);
            return (T)retrier.execute(retriable, this.retryExceptionHandler);
        }
        catch (Exception e) {
            throw (ContentStoreException)((Object)e);
        }
    }

    @Override
    public List<String> getSpaces() throws ContentStoreException {
        return (List)this.execute(new Retriable(){

            public List<String> retry() throws ContentStoreException {
                return ContentStoreImpl.this.doGetSpaces();
            }
        });
    }

    private List<String> doGetSpaces() throws ContentStoreException {
        String task = "get spaces";
        String url = this.buildURL("/spaces");
        url = this.addStoreIdQueryParameter(url);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.get(url);
            this.checkResponse(response, 200);
            String responseText = response.getResponseBody();
            if (responseText != null) {
                ArrayList<String> spaceIds = new ArrayList<String>();
                ByteArrayInputStream is = new ByteArrayInputStream(responseText.getBytes("UTF-8"));
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build((InputStream)is);
                Element spacesElem = doc.getRootElement();
                for (Element spaceElem : spacesElem.getChildren()) {
                    spaceIds.add(spaceElem.getAttributeValue("id"));
                }
                return spaceIds;
            }
            throw new ContentStoreException("Response body is empty");
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(task, "listing", (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException("Error attempting to get spaces due to: " + e.getMessage(), e);
        }
    }

    @Override
    public Iterator<String> getSpaceContents(String spaceId) throws ContentStoreException {
        return this.getSpaceContents(spaceId, null);
    }

    @Override
    public Iterator<String> getSpaceContents(final String spaceId, final String prefix) throws ContentStoreException {
        final ContentStoreImpl store = this;
        return (Iterator)this.execute(new Retriable(){

            public Iterator<String> retry() throws ContentStoreException {
                return new ContentIterator(store, spaceId, prefix);
            }
        });
    }

    @Override
    public Space getSpace(final String spaceId, final String prefix, final long maxResults, final String marker) throws ContentStoreException {
        return (Space)this.execute(new Retriable(){

            public Space retry() throws ContentStoreException {
                return ContentStoreImpl.this.doGetSpace(spaceId, prefix, maxResults, marker);
            }
        });
    }

    private Space doGetSpace(String spaceId, String prefix, long maxResults, String marker) throws ContentStoreException {
        String task = "get space";
        String url = this.buildSpaceURL(spaceId, prefix, maxResults, marker);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.get(url);
            this.checkResponse(response, 200);
            Space space = new Space();
            space.setProperties(this.extractPropertiesFromHeaders(response));
            String responseText = response.getResponseBody();
            if (responseText != null) {
                ByteArrayInputStream is = new ByteArrayInputStream(responseText.getBytes("UTF-8"));
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build((InputStream)is);
                Element spaceElem = doc.getRootElement();
                space.setId(spaceElem.getAttributeValue("id"));
                for (Element contentElem : spaceElem.getChildren()) {
                    space.addContentId(contentElem.getText());
                }
            } else {
                throw new ContentStoreException("Response body is empty");
            }
            return space;
        }
        catch (NotFoundException e) {
            throw new NotFoundException(task, spaceId, (Exception)((Object)e));
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(task, spaceId, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException(task, spaceId, e);
        }
    }

    @Override
    public void createSpace(final String spaceId) throws ContentStoreException {
        this.execute(new Retriable(){

            public Boolean retry() throws ContentStoreException {
                ContentStoreImpl.this.doCreateSpace(spaceId);
                return true;
            }
        });
    }

    private void doCreateSpace(String spaceId) throws ContentStoreException {
        this.validateSpaceId(spaceId);
        String task = "create space";
        String url = this.buildSpaceURL(spaceId);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.put(url, null, null);
            this.checkResponse(response, 201);
        }
        catch (InvalidIdException e) {
            throw new InvalidIdException(task, spaceId, (Exception)((Object)e));
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(task, spaceId, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException(task, spaceId, e);
        }
    }

    @Override
    public void deleteSpace(final String spaceId) throws ContentStoreException {
        this.execute(new Retriable(){

            public Boolean retry() throws ContentStoreException {
                ContentStoreImpl.this.doDeleteSpace(spaceId);
                return true;
            }
        });
    }

    private void doDeleteSpace(String spaceId) throws ContentStoreException {
        String task = "delete space";
        String url = this.buildSpaceURL(spaceId);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.delete(url);
            this.checkResponse(response, 200);
        }
        catch (NotFoundException e) {
            throw new NotFoundException(task, spaceId, (Exception)((Object)e));
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(task, spaceId, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException(task, spaceId, e);
        }
    }

    @Override
    public Map<String, String> getSpaceProperties(final String spaceId) throws ContentStoreException {
        return (Map)this.execute(new Retriable(){

            public Map<String, String> retry() throws ContentStoreException {
                return ContentStoreImpl.this.doGetSpaceProperties(spaceId);
            }
        });
    }

    private Map<String, String> doGetSpaceProperties(String spaceId) throws ContentStoreException {
        String task = "get space properties";
        String url = this.buildSpaceURL(spaceId);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.head(url);
            this.checkResponse(response, 200);
            return this.extractPropertiesFromHeaders(response);
        }
        catch (NotFoundException e) {
            throw new NotFoundException(task, spaceId, (Exception)((Object)e));
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(task, spaceId, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException(task, spaceId, e);
        }
    }

    @Override
    public Map<String, AclType> getSpaceACLs(final String spaceId) throws ContentStoreException {
        return (Map)this.execute(new Retriable(){

            public Map<String, AclType> retry() throws ContentStoreException {
                return ContentStoreImpl.this.doGetSpaceACLs(spaceId);
            }
        });
    }

    private Map<String, AclType> doGetSpaceACLs(String spaceId) throws ContentStoreException {
        String task = "get space ACLs";
        String url = this.buildAclURL(spaceId);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.head(url);
            this.checkResponse(response, 200);
            return this.doGetSpaceACLs(response);
        }
        catch (NotFoundException e) {
            throw new NotFoundException(task, spaceId, (Exception)((Object)e));
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(task, spaceId, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException(task, spaceId, e);
        }
    }

    private Map<String, AclType> doGetSpaceACLs(RestHttpHelper.HttpResponse response) {
        HashMap<String, AclType> acls = new HashMap<String, AclType>();
        Map<String, String> aclProps = this.extractPropertiesFromHeaders(response, "acl-");
        for (String key : aclProps.keySet()) {
            String val = aclProps.get(key);
            acls.put(key, AclType.valueOf((String)val));
        }
        return acls;
    }

    @Override
    public void setSpaceACLs(final String spaceId, final Map<String, AclType> spaceACLs) throws ContentStoreException {
        this.execute(new Retriable(){

            public Boolean retry() throws ContentStoreException {
                ContentStoreImpl.this.doSetSpaceACLs(spaceId, spaceACLs);
                return true;
            }
        });
    }

    private void doSetSpaceACLs(String spaceId, Map<String, AclType> spaceACLs) throws ContentStoreException {
        String task = "set space ACLs";
        String url = this.buildAclURL(spaceId);
        Map<String, String> headers = this.convertAclsToHeaders(spaceACLs);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.post(url, null, headers);
            this.checkResponse(response, 200);
        }
        catch (NotFoundException e) {
            throw new NotFoundException(task, spaceId, (Exception)((Object)e));
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(task, spaceId, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException(task, spaceId, e);
        }
    }

    private Map<String, String> convertAclsToHeaders(Map<String, AclType> acls) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (acls != null) {
            for (String key : acls.keySet()) {
                AclType acl = acls.get(key);
                headers.put("x-dura-meta-acl-" + key, acl.name());
            }
        }
        return headers;
    }

    @Override
    public boolean spaceExists(String spaceId) throws ContentStoreException {
        List<String> spaces = this.getSpaces();
        return spaces.contains(spaceId);
    }

    @Override
    public String addContent(String spaceId, String contentId, InputStream content, long contentSize, String contentMimeType, String contentChecksum, Map<String, String> contentProperties) throws ContentStoreException {
        return this.doAddContent(spaceId, contentId, content, contentSize, contentMimeType, contentChecksum, contentProperties);
    }

    private String doAddContent(String spaceId, String contentId, InputStream content, long contentSize, String contentMimeType, String contentChecksum, Map<String, String> contentProperties) throws ContentStoreException {
        this.validateContentId(contentId);
        String task = "add content";
        String url = this.buildContentURL(spaceId, contentId);
        if (contentMimeType != null && !contentMimeType.equals("")) {
            if (contentProperties == null) {
                contentProperties = new HashMap<String, String>();
            }
            contentProperties.put("content-mimetype", contentMimeType);
        }
        Map<String, String> headers = this.convertPropertiesToHeaders(contentProperties);
        if (contentChecksum != null) {
            headers.put("Content-MD5", contentChecksum);
        }
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.put(url, content, contentMimeType, contentSize, headers);
            this.checkResponse(response, 201);
            Header checksum = response.getResponseHeader("Content-MD5");
            if (checksum == null) {
                checksum = response.getResponseHeader("ETag");
            }
            String returnedChecksum = checksum.getValue();
            if (contentChecksum != null && !returnedChecksum.equals(contentChecksum)) {
                String message = MessageFormat.format("checksum returned from durastore ({0}) does not match the checksum that was sent ({1}): task={2}, spaceId={3}, contentId={4}", returnedChecksum, contentChecksum, task, spaceId, contentId);
                this.log.error(message);
                throw new ChecksumMismatchException(message, false);
            }
            return returnedChecksum;
        }
        catch (InvalidIdException e) {
            throw new InvalidIdException(task, spaceId, contentId, (Exception)((Object)e));
        }
        catch (NotFoundException e) {
            throw new NotFoundException(task, spaceId, contentId, (Exception)((Object)e));
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(task, spaceId, contentId, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException(task, spaceId, contentId, e);
        }
    }

    @Override
    public String copyContent(final String srcSpaceId, final String srcContentId, final String destStoreId, final String destSpaceId, final String destContentId) throws ContentStoreException {
        return (String)this.execute(new Retriable(){

            public String retry() throws ContentStoreException {
                return ContentStoreImpl.this.doCopyContent(srcSpaceId, srcContentId, destStoreId, destSpaceId, destContentId);
            }
        });
    }

    private String doCopyContent(String srcSpaceId, String srcContentId, String destStoreId, String destSpaceId, String destContentId) throws ContentStoreException {
        this.validateStoreId(destStoreId);
        this.validateSpaceId(srcSpaceId);
        this.validateSpaceId(destSpaceId);
        this.validateContentId(srcContentId);
        this.validateContentId(destContentId);
        String task = "copy content";
        srcContentId = EncodeUtil.urlEncode((String)srcContentId);
        String url = this.buildContentURL(destStoreId, destSpaceId, destContentId);
        HashMap<String, String> headers = new HashMap<String, String>();
        String sourceHeader = "x-dura-meta-copy-source";
        String sourceValue = srcSpaceId + "/" + srcContentId;
        headers.put(sourceHeader, sourceValue);
        String storeHeader = "x-dura-meta-copy-source-store";
        headers.put(storeHeader, this.storeId);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.put(url, null, headers);
            this.checkResponse(response, 201);
            Header checksum = response.getResponseHeader("Content-MD5");
            if (checksum == null) {
                checksum = response.getResponseHeader("ETag");
            }
            return checksum.getValue();
        }
        catch (InvalidIdException e) {
            throw new InvalidIdException(task, srcSpaceId, srcContentId, destSpaceId, destContentId, (Exception)((Object)e));
        }
        catch (NotFoundException e) {
            throw new NotFoundException(task, srcSpaceId, srcContentId, destSpaceId, destContentId, (Exception)((Object)e));
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(task, srcSpaceId, srcContentId, destSpaceId, destContentId, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException(task, srcSpaceId, srcContentId, destSpaceId, destContentId, e);
        }
    }

    @Override
    public String copyContent(String srcSpaceId, String srcContentId, String destSpaceId, String destContentId) throws ContentStoreException {
        return this.copyContent(srcSpaceId, srcContentId, this.getStoreId(), destSpaceId, destContentId);
    }

    @Override
    public String moveContent(String srcSpaceId, String srcContentId, String destSpaceId, String destContentId) throws ContentStoreException {
        return this.moveContent(srcSpaceId, srcContentId, this.getStoreId(), destSpaceId, destContentId);
    }

    @Override
    public String moveContent(String srcSpaceId, String srcContentId, String destStoreId, String destSpaceId, String destContentId) throws ContentStoreException {
        String md5 = this.copyContent(srcSpaceId, srcContentId, destStoreId, destSpaceId, destContentId);
        this.deleteContent(srcSpaceId, srcContentId);
        return md5;
    }

    @Override
    public Content getContent(final String spaceId, final String contentId) throws ContentStoreException {
        return (Content)this.execute(new Retriable(){

            public Content retry() throws ContentStoreException {
                return ContentStoreImpl.this.doGetContent(spaceId, contentId);
            }
        });
    }

    private Content doGetContent(String spaceId, String contentId) throws ContentStoreException {
        String task = "get content";
        String url = this.buildContentURL(spaceId, contentId);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.get(url);
            this.checkResponse(response, 200);
            Content content = new Content();
            content.setId(contentId);
            content.setStream(response.getResponseStream());
            content.setProperties(this.mergeMaps(this.extractPropertiesFromHeaders(response), this.extractNonPropertiesHeaders(response)));
            return content;
        }
        catch (NotFoundException e) {
            throw new NotFoundException(task, spaceId, contentId, (Exception)((Object)e));
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(task, spaceId, contentId, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException(task, spaceId, contentId, e);
        }
    }

    @Override
    public void deleteContent(final String spaceId, final String contentId) throws ContentStoreException {
        this.execute(new Retriable(){

            public Boolean retry() throws ContentStoreException {
                ContentStoreImpl.this.doDeleteContent(spaceId, contentId);
                return true;
            }
        });
    }

    private void doDeleteContent(String spaceId, String contentId) throws ContentStoreException {
        String task = "delete content";
        String url = this.buildContentURL(spaceId, contentId);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.delete(url);
            this.checkResponse(response, 200);
        }
        catch (NotFoundException e) {
            throw new NotFoundException(task, spaceId, contentId, (Exception)((Object)e));
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(task, spaceId, contentId, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException(task, spaceId, contentId, e);
        }
    }

    @Override
    public void setContentProperties(final String spaceId, final String contentId, final Map<String, String> contentProperties) throws ContentStoreException {
        this.execute(new Retriable(){

            public Boolean retry() throws ContentStoreException {
                ContentStoreImpl.this.doSetContentProperties(spaceId, contentId, contentProperties);
                return true;
            }
        });
    }

    private void doSetContentProperties(String spaceId, String contentId, Map<String, String> contentProperties) throws ContentStoreException {
        String task = "update content properties";
        String url = this.buildContentURL(spaceId, contentId);
        Map<String, String> headers = this.convertPropertiesToHeaders(contentProperties);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.post(url, null, headers);
            this.checkResponse(response, 200);
        }
        catch (NotFoundException e) {
            throw new NotFoundException(task, spaceId, contentId, (Exception)((Object)e));
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(task, spaceId, contentId, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException(task, spaceId, contentId, e);
        }
    }

    @Override
    public Map<String, String> getContentProperties(final String spaceId, final String contentId) throws ContentStoreException {
        return (Map)this.execute(new Retriable(){

            public Map<String, String> retry() throws ContentStoreException {
                return ContentStoreImpl.this.doGetContentProperties(spaceId, contentId);
            }
        });
    }

    private Map<String, String> doGetContentProperties(String spaceId, String contentId) throws ContentStoreException {
        String task = "get properties";
        String url = this.buildContentURL(spaceId, contentId);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.head(url);
            this.checkResponse(response, 200);
            return this.mergeMaps(this.extractPropertiesFromHeaders(response), this.extractNonPropertiesHeaders(response));
        }
        catch (NotFoundException e) {
            throw new NotFoundException(task, spaceId, contentId, (Exception)((Object)e));
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(task, spaceId, contentId, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException(task, spaceId, contentId, e);
        }
    }

    @Override
    public boolean contentExists(String spaceId, String contentId) throws ContentStoreException {
        try {
            this.doGetContentProperties(spaceId, contentId);
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    private void checkResponse(RestHttpHelper.HttpResponse response, int expectedCode) throws ContentStoreException {
        if (response == null) {
            throw new ContentStoreException("Response content was null.");
        }
        int responseCode = response.getStatusCode();
        if (responseCode != expectedCode) {
            String errMsg = "";
            try {
                errMsg = errMsg + response.getResponseBody();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.log.warn("Return code: {}; expected code: {}; responseBody={}", new Object[]{responseCode, expectedCode, errMsg});
            if (responseCode == 404) {
                throw new NotFoundException(errMsg);
            }
            if (responseCode == 400) {
                throw new InvalidIdException(errMsg);
            }
            if (responseCode == 401) {
                throw new UnauthorizedException(errMsg);
            }
            if (responseCode == 501) {
                throw new NotImplementedException(errMsg);
            }
            if (responseCode == 403) {
                throw new UnauthorizedException("User is not authorized to perform the requested function");
            }
            if (responseCode == 409) {
                throw new ContentStateException(errMsg);
            }
            throw new ContentStoreException(errMsg);
        }
    }

    private Map<String, String> convertPropertiesToHeaders(Map<String, String> properties) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (properties != null) {
            for (String key : properties.keySet()) {
                headers.put(HEADER_PREFIX + key, properties.get(key));
            }
        }
        headers.put("x-dura-client-version", this.clientVersion);
        return headers;
    }

    private Map<String, String> extractPropertiesFromHeaders(RestHttpHelper.HttpResponse response) {
        return this.extractPropertiesFromHeaders(response, null);
    }

    private Map<String, String> extractPropertiesFromHeaders(RestHttpHelper.HttpResponse response, String keyPrefix) {
        HashMap<String, String> properties = new HashMap<String, String>();
        String prefix = HEADER_PREFIX + (keyPrefix != null ? keyPrefix : "");
        for (Header header : response.getResponseHeaders()) {
            String name = header.getName();
            if (!name.startsWith(prefix)) continue;
            properties.put(name.substring(prefix.length()), header.getValue());
        }
        return properties;
    }

    private Map<String, String> extractNonPropertiesHeaders(RestHttpHelper.HttpResponse response) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Header header : response.getResponseHeaders()) {
            String name = header.getName();
            if (name.startsWith(HEADER_PREFIX)) continue;
            if (name.equals("Content-Type")) {
                headers.put("content-mimetype", header.getValue());
                continue;
            }
            if (name.equals("Content-MD5") || name.equals("ETag")) {
                headers.put("content-checksum", header.getValue());
                continue;
            }
            if (name.equals("Content-Length")) {
                headers.put("content-size", header.getValue());
                continue;
            }
            if (!name.equals("Last-Modified")) continue;
            headers.put("content-modified", header.getValue());
        }
        return headers;
    }

    private Map<String, String> mergeMaps(Map<String, String> map1, Map<String, String> map2) {
        for (String name : map1.keySet()) {
            map2.put(name, map1.get(name));
        }
        return map2;
    }

    public void validateStoreId(String storeId) throws InvalidIdException {
        try {
            IdUtil.validateStoreId((String)storeId);
        }
        catch (org.duracloud.storage.error.InvalidIdException e) {
            throw new InvalidIdException(e.getMessage());
        }
    }

    @Override
    public void validateSpaceId(String spaceId) throws InvalidIdException {
        try {
            IdUtil.validateSpaceId((String)spaceId);
        }
        catch (org.duracloud.storage.error.InvalidIdException e) {
            throw new InvalidIdException(e.getMessage());
        }
    }

    @Override
    public void validateContentId(String contentId) throws InvalidIdException {
        try {
            IdUtil.validateContentId((String)contentId);
        }
        catch (org.duracloud.storage.error.InvalidIdException e) {
            throw new InvalidIdException(e.getMessage());
        }
    }

    @Override
    public List<String> getSupportedTasks() throws ContentStoreException {
        return (List)this.execute(new Retriable(){

            public List<String> retry() throws ContentStoreException {
                return ContentStoreImpl.this.doGetSupportedTasks();
            }
        });
    }

    private List<String> doGetSupportedTasks() throws ContentStoreException {
        String url = this.buildTaskURL();
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.get(url);
            this.checkResponse(response, 200);
            String reponseText = response.getResponseBody();
            return SerializationUtil.deserializeList((String)reponseText);
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException("Not authorized to get supported tasks", (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException("Error getting supported tasks: " + e.getMessage(), e);
        }
    }

    @Override
    public String performTask(final String taskName, final String taskParameters) throws ContentStoreException {
        return (String)this.execute(new Retriable(){

            public String retry() throws ContentStoreException {
                return ContentStoreImpl.this.doPerformTask(taskName, taskParameters);
            }
        });
    }

    @Override
    public String performTaskWithNoRetries(String taskName, String taskParameters) throws ContentStoreException {
        return this.doPerformTask(taskName, taskParameters);
    }

    private String doPerformTask(String taskName, String taskParameters) throws ContentStoreException {
        String url = this.buildTaskURL(taskName);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.post(url, taskParameters, null);
            this.checkResponse(response, 200);
            return response.getResponseBody();
        }
        catch (InvalidIdException e) {
            throw new UnsupportedTaskException(taskName, (Throwable)((Object)e));
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException("Not authorized to perform task: " + taskName, (Exception)((Object)e));
        }
        catch (ContentStateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ContentStoreException("Error performing task (" + taskName + "):  " + e.getMessage(), e);
        }
    }

    @Override
    public InputStream getManifest(String spaceId, ManifestFormat format) throws ContentStoreException {
        String task = "get manifest";
        String url = this.buildManifestURL(spaceId, format);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.get(url);
            this.checkResponse(response, 200);
            return response.getResponseStream();
        }
        catch (NotFoundException e) {
            throw new NotFoundException(task, spaceId, (Exception)((Object)e));
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(task, spaceId, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException(task, spaceId, e);
        }
    }

    private String buildManifestURL(String spaceId, ManifestFormat format) {
        String url = this.buildURL("/manifest/" + spaceId);
        url = this.addStoreIdQueryParameter(url);
        if (format != null) {
            url = url + "&format=" + format.name();
        }
        return url;
    }

    @Override
    public InputStream getAuditLog(String spaceId) throws ContentStoreException {
        String task = "get manifest";
        String url = this.buildAuditLogURL(spaceId);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.get(url);
            this.checkResponse(response, 200);
            return response.getResponseStream();
        }
        catch (NotFoundException e) {
            throw new NotFoundException(task, spaceId, (Exception)((Object)e));
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(task, spaceId, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException(task, spaceId, e);
        }
    }

    private String buildAuditLogURL(String spaceId) {
        String url = this.buildURL("/audit/" + spaceId);
        url = this.addStoreIdQueryParameter(url);
        return url;
    }

    @Override
    public BitIntegrityReport getBitIntegrityReport(String spaceId) throws ContentStoreException {
        String task = "get bit integrity report";
        String url = this.buildBitIntegrityReportURL(spaceId);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.get(url);
            if (this.hasNoContent(response)) {
                return null;
            }
            this.checkResponse(response, 200);
            BitIntegrityReportProperties properties = this.getBitIntegrityReportProperties(spaceId);
            BitIntegrityReport report = new BitIntegrityReport(response.getResponseStream(), properties);
            return report;
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(task, spaceId, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException(task, spaceId, e);
        }
    }

    private boolean hasNoContent(RestHttpHelper.HttpResponse response) {
        return response.getStatusCode() == 204;
    }

    @Override
    public BitIntegrityReportProperties getBitIntegrityReportProperties(String spaceId) throws ContentStoreException {
        String task = "get bit integrity report properties";
        String url = this.buildBitIntegrityReportURL(spaceId);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.head(url);
            if (this.hasNoContent(response)) {
                return null;
            }
            this.checkResponse(response, 200);
            return this.extractBitIntegrityProperties(response);
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(task, spaceId, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException(task, spaceId, e);
        }
    }

    private String buildBitIntegrityReportURL(String spaceId) {
        String url = this.buildURL("/bit-integrity/" + spaceId);
        url = this.addStoreIdQueryParameter(url);
        return url;
    }

    private BitIntegrityReportProperties extractBitIntegrityProperties(RestHttpHelper.HttpResponse response) throws ParseException {
        BitIntegrityReportProperties properties = new BitIntegrityReportProperties();
        for (Header header : response.getResponseHeaders()) {
            String name = header.getName();
            if (name.equals("Bit-Integrity-Report-Result")) {
                properties.setResult(BitIntegrityReportResult.valueOf((String)header.getValue()));
                continue;
            }
            if (name.equals("Bit-Integrity-Report-Completion-Date")) {
                SimpleDateFormat format = new SimpleDateFormat(DateUtil.DateFormat.DEFAULT_FORMAT.getPattern());
                properties.setCompletionDate(format.parse(header.getValue()));
                continue;
            }
            if (!name.equals("Content-Length")) continue;
            properties.setSize(Long.valueOf(header.getValue()).longValue());
        }
        return properties;
    }

    @Override
    public SpaceStatsDTOList getSpaceStats(String spaceId, Date start, Date end) throws ContentStoreException {
        String url = this.buildSpaceStatsURL(spaceId, start, end);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.get(url);
            this.checkResponse(response, 200);
            String body = response.getResponseBody();
            JaxbJsonSerializer serializer = new JaxbJsonSerializer(SpaceStatsDTOList.class);
            return (SpaceStatsDTOList)serializer.deserialize(body);
        }
        catch (NotFoundException e) {
            throw new NotFoundException("spaceId = " + spaceId);
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(spaceId, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException("failed to retrieve space stats for " + spaceId, e);
        }
    }

    private String buildSpaceStatsURL(String spaceId, Date start, Date end) {
        String url = this.buildURL("/report/space/" + spaceId);
        if (start != null) {
            url = this.addQueryParameter(url, "start", start.getTime() + "");
        }
        if (end != null) {
            url = this.addQueryParameter(url, "end", end.getTime() + "");
        }
        url = this.addStoreIdQueryParameter(url);
        return url;
    }

    @Override
    public SpaceStatsDTOList getStorageProviderStats(Date start, Date end) throws ContentStoreException {
        String url = this.buildStorageProviderStatsURL(start, end);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.get(url);
            this.checkResponse(response, 200);
            String body = response.getResponseBody();
            JaxbJsonSerializer serializer = new JaxbJsonSerializer(SpaceStatsDTOList.class);
            return (SpaceStatsDTOList)serializer.deserialize(body);
        }
        catch (NotFoundException e) {
            throw new NotFoundException("storeId = " + this.getStoreId());
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(this.getStoreId(), (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException("failed to retrieve storage provider stats for " + this.getStoreId(), e);
        }
    }

    private String buildStorageProviderStatsURL(Date start, Date end) {
        String url = this.buildURL("/report/store");
        if (start != null) {
            url = this.addQueryParameter(url, "start", start.getTime() + "");
        }
        if (end != null) {
            url = this.addQueryParameter(url, "end", end.getTime() + "");
        }
        url = this.addStoreIdQueryParameter(url);
        return url;
    }

    @Override
    public SpaceStatsDTOList getStorageProviderStatsByDay(Date date) throws ContentStoreException {
        String url = this.buildStorageProviderStatsURL(date);
        try {
            RestHttpHelper.HttpResponse response = this.restHelper.get(url);
            this.checkResponse(response, 200);
            String body = response.getResponseBody();
            JaxbJsonSerializer serializer = new JaxbJsonSerializer(SpaceStatsDTOList.class);
            return (SpaceStatsDTOList)serializer.deserialize(body);
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(this.storeId, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ContentStoreException("failed to retrieve storage provider stats for " + this.storeId, e);
        }
    }

    private String buildStorageProviderStatsURL(Date date) {
        String url = this.buildURL("/report/store/" + date.getTime());
        url = this.addStoreIdQueryParameter(url);
        return url;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }
}

