/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.client;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.duracloud.client.ContentStore;
import org.duracloud.client.ContentStoreImpl;
import org.duracloud.client.ContentStoreManager;
import org.duracloud.common.model.Credential;
import org.duracloud.common.model.Securable;
import org.duracloud.common.web.RestHttpHelper;
import org.duracloud.error.ContentStoreException;
import org.duracloud.storage.domain.StorageAccount;
import org.duracloud.storage.domain.StorageAccountManager;
import org.duracloud.storage.domain.StorageProviderType;
import org.duracloud.storage.error.StorageException;
import org.duracloud.storage.xml.StorageAccountsDocumentBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentStoreManagerImpl
implements ContentStoreManager,
Securable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String DEFAULT_CONTEXT = "durastore";
    private String baseURL = null;
    private RestHttpHelper restHelper;

    public ContentStoreManagerImpl(String host, String port) {
        this(host, port, DEFAULT_CONTEXT);
    }

    public ContentStoreManagerImpl(String host, String port, String context) {
        this.init(host, port, context);
    }

    private void init(String host, String port, String context) {
        if (host == null || host.equals("")) {
            throw new IllegalArgumentException("Host must be a valid server host name");
        }
        if (context == null) {
            context = DEFAULT_CONTEXT;
        }
        this.baseURL = port == null || port.equals("") ? "http://" + host + "/" + context : (port.equals("443") ? "https://" + host + "/" + context : "http://" + host + ":" + port + "/" + context);
    }

    @Override
    public void reinitialize(String host, String port, String context) throws ContentStoreException {
        this.init(host, port, context);
    }

    @Override
    public Map<String, ContentStore> getContentStores() throws ContentStoreException {
        return this.getContentStores(-1);
    }

    @Override
    public Map<String, ContentStore> getContentStores(int maxRetries) throws ContentStoreException {
        this.log.debug("getContentStores()");
        StorageAccountManager acctManager = this.getStorageAccounts();
        Map accounts = acctManager.getStorageAccounts();
        HashMap<String, ContentStore> contentStores = new HashMap<String, ContentStore>();
        for (String acctID : accounts.keySet()) {
            StorageAccount acct = (StorageAccount)accounts.get(acctID);
            contentStores.put(acctID, this.newContentStoreImpl(acct, maxRetries));
        }
        return contentStores;
    }

    @Override
    public ContentStore getContentStore(String storeID) throws ContentStoreException {
        return this.getContentStore(storeID, -1);
    }

    @Override
    public ContentStore getContentStore(String storeID, int maxRetries) throws ContentStoreException {
        StorageAccountManager acctManager = this.getStorageAccounts();
        StorageAccount acct = acctManager.getStorageAccount(storeID);
        if (acct == null) {
            throw new ContentStoreException("Content store with id = '" + storeID + "' not found.");
        }
        return this.newContentStoreImpl(acct, maxRetries);
    }

    @Override
    public ContentStore getPrimaryContentStore() throws ContentStoreException {
        return this.getPrimaryContentStore(-1);
    }

    @Override
    public ContentStore getPrimaryContentStore(int maxRetries) throws ContentStoreException {
        StorageAccountManager acctManager = this.getStorageAccounts();
        StorageAccount acct = acctManager.getPrimaryStorageAccount();
        return this.newContentStoreImpl(acct, maxRetries);
    }

    @Override
    public ContentStore getPrimaryContentStoreAsAnonymous() throws ContentStoreException {
        return this.getPrimaryContentStoreAsAnonymous(-1);
    }

    @Override
    public ContentStore getPrimaryContentStoreAsAnonymous(int maxRetries) throws ContentStoreException {
        return this.newAnonymousContentStoreImpl(maxRetries);
    }

    public void login(Credential appCred) {
        this.log.debug("login: " + appCred.getUsername());
        this.setRestHelper(new RestHttpHelper(appCred));
    }

    public void logout() {
        this.log.debug("logout");
        this.setRestHelper(new RestHttpHelper());
    }

    private StorageAccountManager getStorageAccounts() throws ContentStoreException {
        String url = this.baseURL + "/stores";
        String error = "Error retrieving content stores. ";
        try {
            RestHttpHelper.HttpResponse response = this.getRestHelper().get(url);
            if (response.getStatusCode() == 200) {
                String storesXML = response.getResponseBody();
                if (storesXML != null) {
                    ByteArrayInputStream xmlStream = new ByteArrayInputStream(storesXML.getBytes("UTF-8"));
                    StorageAccountsDocumentBinding binding = new StorageAccountsDocumentBinding();
                    List accts = binding.createStorageAccountsFromXml((InputStream)xmlStream);
                    StorageAccountManager storageAccountManager = new StorageAccountManager();
                    storageAccountManager.initialize(accts);
                    return storageAccountManager;
                }
                throw new StorageException(error + "Response content was null");
            }
            error = error + "Response code was " + response.getStatusCode() + ", expected value was " + 200 + ". Response Body: " + response.getResponseBody();
            throw new StorageException(error);
        }
        catch (Exception e) {
            throw new ContentStoreException(error + e.getMessage(), e);
        }
    }

    protected ContentStore newContentStoreImpl(StorageAccount acct) {
        return new ContentStoreImpl(this.baseURL, acct.getType(), acct.getId(), this.getRestHelper());
    }

    protected ContentStore newContentStoreImpl(StorageAccount acct, int maxRetries) {
        return new ContentStoreImpl(this.baseURL, acct.getType(), acct.getId(), this.getRestHelper(), maxRetries);
    }

    private ContentStore newAnonymousContentStoreImpl() {
        return new ContentStoreImpl(this.baseURL, StorageProviderType.UNKNOWN, null, this.getRestHelper());
    }

    private ContentStore newAnonymousContentStoreImpl(int maxRetries) {
        return new ContentStoreImpl(this.baseURL, StorageProviderType.UNKNOWN, null, this.getRestHelper(), maxRetries);
    }

    protected String getBaseURL() {
        return this.baseURL;
    }

    protected RestHttpHelper getRestHelper() {
        if (null == this.restHelper) {
            this.restHelper = new RestHttpHelper();
        }
        return this.restHelper;
    }

    protected void setRestHelper(RestHttpHelper restHelper) {
        this.restHelper = restHelper;
    }
}

