/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.client.task;

import org.duracloud.client.ContentStore;
import org.duracloud.client.task.S3TaskClient;
import org.duracloud.error.ContentStoreException;
import org.duracloud.s3storageprovider.dto.DeleteStreamingTaskParameters;
import org.duracloud.s3storageprovider.dto.DeleteStreamingTaskResult;
import org.duracloud.s3storageprovider.dto.DisableStreamingTaskParameters;
import org.duracloud.s3storageprovider.dto.DisableStreamingTaskResult;
import org.duracloud.s3storageprovider.dto.EnableStreamingTaskParameters;
import org.duracloud.s3storageprovider.dto.EnableStreamingTaskResult;
import org.duracloud.s3storageprovider.dto.GetHlsUrlTaskParameters;
import org.duracloud.s3storageprovider.dto.GetSignedCookiesUrlTaskParameters;
import org.duracloud.s3storageprovider.dto.GetSignedCookiesUrlTaskResult;
import org.duracloud.s3storageprovider.dto.GetSignedUrlTaskParameters;
import org.duracloud.s3storageprovider.dto.GetSignedUrlTaskResult;
import org.duracloud.s3storageprovider.dto.GetUrlTaskParameters;
import org.duracloud.s3storageprovider.dto.GetUrlTaskResult;

public class S3TaskClientImpl
implements S3TaskClient {
    private ContentStore contentStore;

    public S3TaskClientImpl(ContentStore contentStore) {
        this.contentStore = contentStore;
    }

    @Override
    public EnableStreamingTaskResult enableStreaming(String spaceId, boolean secure) throws ContentStoreException {
        EnableStreamingTaskParameters taskParams = new EnableStreamingTaskParameters();
        taskParams.setSpaceId(spaceId);
        taskParams.setSecure(secure);
        return EnableStreamingTaskResult.deserialize((String)this.contentStore.performTask("enable-streaming", taskParams.serialize()));
    }

    @Override
    public DisableStreamingTaskResult disableStreaming(String spaceId) throws ContentStoreException {
        DisableStreamingTaskParameters taskParams = new DisableStreamingTaskParameters();
        taskParams.setSpaceId(spaceId);
        return DisableStreamingTaskResult.deserialize((String)this.contentStore.performTask("disable-streaming", taskParams.serialize()));
    }

    @Override
    public DeleteStreamingTaskResult deleteStreaming(String spaceId) throws ContentStoreException {
        DeleteStreamingTaskParameters taskParams = new DeleteStreamingTaskParameters();
        taskParams.setSpaceId(spaceId);
        return DeleteStreamingTaskResult.deserialize((String)this.contentStore.performTask("delete-streaming", taskParams.serialize()));
    }

    @Override
    public GetUrlTaskResult getUrl(String spaceId, String contentId, String resourcePrefix) throws ContentStoreException {
        GetUrlTaskParameters taskParams = new GetUrlTaskParameters();
        taskParams.setSpaceId(spaceId);
        taskParams.setContentId(contentId);
        taskParams.setResourcePrefix(resourcePrefix);
        return GetUrlTaskResult.deserialize((String)this.contentStore.performTask("get-url", taskParams.serialize()));
    }

    @Override
    public GetSignedUrlTaskResult getSignedUrl(String spaceId, String contentId, String resourcePrefix) throws ContentStoreException {
        int defaultExpire = -1;
        return this.getSignedUrl(spaceId, contentId, resourcePrefix, defaultExpire, null);
    }

    @Override
    public GetSignedUrlTaskResult getSignedUrl(String spaceId, String contentId, String resourcePrefix, int minutesToExpire, String ipAddress) throws ContentStoreException {
        GetSignedUrlTaskParameters taskParams = new GetSignedUrlTaskParameters();
        taskParams.setSpaceId(spaceId);
        taskParams.setContentId(contentId);
        taskParams.setResourcePrefix(resourcePrefix);
        taskParams.setMinutesToExpire(minutesToExpire);
        taskParams.setIpAddress(ipAddress);
        return GetSignedUrlTaskResult.deserialize((String)this.contentStore.performTask("get-signed-url", taskParams.serialize()));
    }

    @Override
    public EnableStreamingTaskResult enableHlsStreaming(String spaceId, boolean secure) throws ContentStoreException {
        EnableStreamingTaskParameters taskParams = new EnableStreamingTaskParameters();
        taskParams.setSpaceId(spaceId);
        taskParams.setSecure(secure);
        return EnableStreamingTaskResult.deserialize((String)this.contentStore.performTask("enable-hls", taskParams.serialize()));
    }

    @Override
    public DisableStreamingTaskResult disableHlsStreaming(String spaceId) throws ContentStoreException {
        DisableStreamingTaskParameters taskParams = new DisableStreamingTaskParameters();
        taskParams.setSpaceId(spaceId);
        return DisableStreamingTaskResult.deserialize((String)this.contentStore.performTask("disable-hls", taskParams.serialize()));
    }

    @Override
    public DeleteStreamingTaskResult deleteHlsStreaming(String spaceId) throws ContentStoreException {
        DeleteStreamingTaskParameters taskParams = new DeleteStreamingTaskParameters();
        taskParams.setSpaceId(spaceId);
        return DeleteStreamingTaskResult.deserialize((String)this.contentStore.performTask("delete-hls", taskParams.serialize()));
    }

    @Override
    public GetUrlTaskResult getHlsUrl(String spaceId, String contentId) throws ContentStoreException {
        GetHlsUrlTaskParameters params = new GetHlsUrlTaskParameters();
        params.setSpaceId(spaceId);
        params.setContentId(contentId);
        return GetUrlTaskResult.deserialize((String)this.contentStore.performTask("get-url-hls", params.serialize()));
    }

    @Override
    public GetSignedCookiesUrlTaskResult getSignedCookiesUrl(String spaceId, String ipAddress, int minutesToExpire, String redirectUrl) throws ContentStoreException {
        GetSignedCookiesUrlTaskParameters params = new GetSignedCookiesUrlTaskParameters();
        params.setSpaceId(spaceId);
        params.setIpAddress(ipAddress);
        params.setMinutesToExpire(minutesToExpire);
        params.setRedirectUrl(redirectUrl);
        return GetSignedCookiesUrlTaskResult.deserialize((String)this.contentStore.performTask("get-signed-cookies-url", params.serialize()));
    }
}

