/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.swiftstorage;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.duracloud.s3storage.S3ProviderUtil;
import org.duracloud.s3storage.S3StorageProvider;
import org.duracloud.storage.domain.StorageProviderType;
import org.duracloud.storage.error.NotFoundException;
import org.duracloud.storage.error.StorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwiftStorageProvider
extends S3StorageProvider {
    private final Logger log = LoggerFactory.getLogger(SwiftStorageProvider.class);

    public SwiftStorageProvider(String accessKey, String secretKey, Map<String, String> options) {
        super(accessKey, secretKey, options);
    }

    public SwiftStorageProvider(AmazonS3 s3Client, String accessKey) {
        super(s3Client, accessKey, null);
    }

    public StorageProviderType getStorageProviderType() {
        return StorageProviderType.SWIFT_S3;
    }

    protected Bucket createBucket(String spaceId) {
        String bucketName = this.getNewBucketName(spaceId);
        try {
            Bucket bucket = this.s3Client.createBucket(bucketName);
            return bucket;
        }
        catch (AmazonClientException e) {
            String err = "Could not create Swift container with name " + bucketName + " due to error: " + e.getMessage();
            throw new StorageException(err, (Throwable)e, true);
        }
    }

    public void removeSpace(String spaceId) {
        String bucketName = this.getBucketName(spaceId);
        String propertiesBucketName = this.getBucketName("space-properties");
        try {
            this.s3Client.deleteBucket(bucketName);
        }
        catch (AmazonClientException e) {
            String err = "Could not delete Swift container with name " + bucketName + " due to error: " + e.getMessage();
            throw new StorageException(err, (Throwable)e, true);
        }
        this.s3Client.deleteObject(propertiesBucketName, spaceId);
    }

    public String createHiddenSpace(String spaceId, int expirationInDays) {
        String bucketName = this.getHiddenBucketName(spaceId);
        try {
            Bucket bucket = this.s3Client.createBucket(bucketName);
            return spaceId;
        }
        catch (AmazonClientException e) {
            String err = "Could not create Swift container with name " + bucketName + " due to error: " + e.getMessage();
            throw new StorageException(err, (Throwable)e, true);
        }
    }

    protected String getNewBucketName(String spaceId) {
        String truncatedKey = this.truncateKey(this.accessKeyId);
        return S3ProviderUtil.createNewBucketName((String)truncatedKey, (String)spaceId);
    }

    protected String getSpaceId(String bucketName) {
        String spaceId = bucketName;
        String truncatedKey = this.truncateKey(this.accessKeyId);
        if (this.isSpace(bucketName)) {
            spaceId = spaceId.substring(truncatedKey.length() + 1);
        }
        return spaceId;
    }

    protected Map<String, String> getAllSpaceProperties(String spaceId) {
        this.log.debug("getAllSpaceProperties(" + spaceId + ")");
        String propsBucketName = this.getBucketName("space-properties");
        Map<String, String> spaceProperties = new HashMap();
        try {
            String[] spacePropertiesList;
            String spacePropertiesString = this.s3Client.getObjectAsString(propsBucketName, spaceId);
            spacePropertiesString = spacePropertiesString.substring(1, spacePropertiesString.length() - 1);
            for (String property : spacePropertiesList = spacePropertiesString.split(", ")) {
                String[] props = property.split("=");
                spaceProperties.put(props[0], props[1]);
            }
        }
        catch (AmazonS3Exception e) {
            this.log.debug("Metadata object for space " + spaceId + " was not found in container " + propsBucketName + ", probably because this is a new space.");
        }
        spaceProperties = this.replaceInMapValues(spaceProperties, "+", "@");
        spaceProperties.put("space-count", this.getSpaceCount(spaceId, 1000));
        return spaceProperties;
    }

    protected void doSetSpaceProperties(String spaceId, Map<String, String> spaceProperties) {
        Map<String, String> originalProperties;
        this.log.debug("setSpaceProperties(" + spaceId + ")");
        try {
            originalProperties = this.getAllSpaceProperties(spaceId);
        }
        catch (NotFoundException e) {
            this.createHiddenSpace("space-properties", 0);
            originalProperties = new HashMap<String, String>();
        }
        String metadataBucketName = this.getBucketName("space-properties");
        String creationDate = originalProperties.get("space-created");
        if (creationDate == null && (creationDate = spaceProperties.get("space-created")) == null) {
            creationDate = this.formattedDate(new Date());
        }
        spaceProperties.put((String)"space-created", (String)creationDate);
        spaceProperties = this.replaceInMapValues(spaceProperties, "@", "+");
        this.log.debug("Writing space properties " + spaceProperties.toString() + " to object " + spaceId + " in Swift container " + metadataBucketName);
        this.s3Client.putObject(metadataBucketName, spaceId, spaceProperties.toString());
    }

    protected void updateObjectProperties(String bucketName, String contentId, ObjectMetadata objMetadata) {
        try {
            AccessControlList originalACL = this.s3Client.getObjectAcl(bucketName, contentId);
            CopyObjectRequest copyRequest = new CopyObjectRequest(bucketName, contentId, bucketName, contentId);
            copyRequest.setStorageClass(DEFAULT_STORAGE_CLASS);
            copyRequest.setNewObjectMetadata(objMetadata);
            copyRequest.setAccessControlList(originalACL);
            this.s3Client.copyObject(copyRequest);
        }
        catch (AmazonClientException e) {
            this.throwIfContentNotExist(bucketName, contentId);
            String err = "Could not update metadata for content " + contentId + " in Swift container " + bucketName + " due to error: " + e.getMessage();
            throw new StorageException(err, (Throwable)e, false);
        }
    }

    protected Map<String, String> prepContentProperties(ObjectMetadata objMetadata) {
        Date modified;
        String checksum;
        long contentLength;
        String encoding;
        HashMap<String, String> contentProperties = new HashMap<String, String>();
        Map userProperties = objMetadata.getUserMetadata();
        for (Object metaName : userProperties.keySet()) {
            String metaValue = (String)userProperties.get(metaName);
            contentProperties.put(this.getWithSpace(SwiftStorageProvider.decodeHeaderKey((String)metaName)), SwiftStorageProvider.decodeHeaderValue((String)metaValue));
        }
        Map responseMeta = objMetadata.getRawMetadata();
        for (String metaName : responseMeta.keySet()) {
            Object metaValue;
            if (this.isSwiftMetadata(metaName) || !((metaValue = responseMeta.get(metaName)) instanceof String)) continue;
            contentProperties.put(metaName, (String)metaValue);
        }
        String contentType = objMetadata.getContentType();
        if (contentType != null) {
            contentProperties.put("content-mimetype", contentType);
            contentProperties.put("Content-Type", contentType);
        }
        if ((encoding = objMetadata.getContentEncoding()) != null) {
            contentProperties.put("Content-Encoding", encoding);
        }
        if ((contentLength = objMetadata.getContentLength()) >= 0L) {
            String size = String.valueOf(contentLength);
            contentProperties.put("content-size", size);
            contentProperties.put("Content-Length", size);
        }
        if ((checksum = objMetadata.getETag()) != null) {
            String eTagValue = this.getETagValue(checksum);
            contentProperties.put("content-checksum", eTagValue);
            contentProperties.put("content-md5", eTagValue);
            contentProperties.put("ETag", eTagValue);
        }
        if ((modified = objMetadata.getLastModified()) != null) {
            String modDate = this.formattedDate(modified);
            contentProperties.put("content-modified", modDate);
            contentProperties.put("Last-Modified", modDate);
        }
        return contentProperties;
    }

    private String truncateKey(String accessKey) {
        return StringUtils.left((String)accessKey, (int)20);
    }

    private boolean isSwiftMetadata(String metaName) {
        return metaName.equalsIgnoreCase("x-openstack-request-id") || metaName.equalsIgnoreCase("x-trans-id");
    }
}

