/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.syncoptimize.config;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.duracloud.common.util.CommandLineToolUtil;
import org.duracloud.common.util.ConsolePrompt;
import org.duracloud.syncoptimize.config.SyncOptimizeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncOptimizeConfigParser {
    private final Logger logger = LoggerFactory.getLogger(SyncOptimizeConfigParser.class);
    protected static final int DEFAULT_PORT = 443;
    public static final String DEFAULT_CONTEXT = "durastore";
    protected static final int DEFAULT_NUM_FILES = 10;
    protected static final int DEFAULT_SIZE_FILES = 5;
    private Options cmdOptions;
    private CommandLineToolUtil cmdLineUtil = new CommandLineToolUtil();

    public SyncOptimizeConfigParser() {
        this.cmdOptions = new Options();
        Option hostOption = new Option("h", "host", true, "the host address of the DuraCloud DuraStore application");
        hostOption.setRequired(true);
        this.cmdOptions.addOption(hostOption);
        Option portOption = new Option("r", "port", true, "the port of the DuraCloud DuraStore application (optional, default value is 443)");
        portOption.setRequired(false);
        this.cmdOptions.addOption(portOption);
        Option usernameOption = new Option("u", "username", true, "the username necessary to perform writes to DuraStore");
        usernameOption.setRequired(true);
        this.cmdOptions.addOption(usernameOption);
        Option passwordOption = new Option("p", "password", true, "the password necessary to perform writes to DuraStore; NOTICE: if no password is specified in the command line the retrieval tool will look for an environment variable named DURACLOUD_PASSWORD containing the password.  Finally, if this environment variable does not exist the user will be prompted for the password.");
        passwordOption.setRequired(false);
        this.cmdOptions.addOption(passwordOption);
        Option spaceIdOption = new Option("s", "space", true, "the space in which test content will be placed");
        spaceIdOption.setRequired(true);
        spaceIdOption.setArgs(-2);
        this.cmdOptions.addOption(spaceIdOption);
        Option numFilesOption = new Option("n", "num-files", true, "the number of files to transfer on each test run");
        numFilesOption.setRequired(false);
        this.cmdOptions.addOption(numFilesOption);
        Option sizeFilesOption = new Option("m", "size-files", true, "the size of files to transfer on each test run, in MB");
        sizeFilesOption.setRequired(false);
        this.cmdOptions.addOption(sizeFilesOption);
    }

    public SyncOptimizeConfig processCommandLine(String[] args) {
        SyncOptimizeConfig config = null;
        try {
            config = this.processOptions(args);
        }
        catch (ParseException e) {
            this.printHelp(e.getMessage());
        }
        return config;
    }

    protected SyncOptimizeConfig processOptions(String[] args) throws ParseException {
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(this.cmdOptions, args);
        SyncOptimizeConfig config = new SyncOptimizeConfig();
        config.setContext(DEFAULT_CONTEXT);
        config.setHost(cmd.getOptionValue("h"));
        config.setUsername(cmd.getOptionValue("u"));
        config.setSpaceId(cmd.getOptionValue("s"));
        if (null != cmd.getOptionValue("p")) {
            config.setPassword(cmd.getOptionValue("p"));
        } else if (null != this.getPasswordEnvVariable()) {
            config.setPassword(this.getPasswordEnvVariable());
        } else {
            ConsolePrompt console = this.getConsole();
            if (null == console) {
                this.printHelp("You must either specify a password in the command line or specify the DURACLOUD_PASSWORD environmental variable.");
            } else {
                char[] password = console.readPassword("DuraCloud password: ", new Object[0]);
                config.setPassword(new String(password));
            }
        }
        if (cmd.hasOption("r")) {
            try {
                config.setPort(Integer.valueOf(cmd.getOptionValue("r")));
            }
            catch (NumberFormatException e) {
                throw new ParseException("The value for port (-r) must be a number.");
            }
        } else {
            config.setPort(443);
        }
        if (cmd.hasOption("n")) {
            try {
                config.setNumFiles(Integer.valueOf(cmd.getOptionValue("n")));
            }
            catch (NumberFormatException e) {
                throw new ParseException("The value for num-files (-n) must be a number.");
            }
        } else {
            config.setNumFiles(10);
        }
        if (cmd.hasOption("m")) {
            try {
                config.setSizeFiles(Integer.valueOf(cmd.getOptionValue("m")));
            }
            catch (NumberFormatException e) {
                throw new ParseException("The value for size-files (-m) must be a number.");
            }
        } else {
            config.setSizeFiles(5);
        }
        return config;
    }

    private void printHelp(String message) {
        System.out.println("\n-----------------------\n" + message + "\n-----------------------\n");
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("Running Sync Thread Optimizer", this.cmdOptions);
        System.exit(1);
    }

    protected String getPasswordEnvVariable() {
        return this.cmdLineUtil.getPasswordEnvVariable();
    }

    protected ConsolePrompt getConsole() {
        return this.cmdLineUtil.getConsole();
    }
}

