/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.codecommit.model.UpdateRepositoryDescriptionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class UpdateRepositoryDescriptionRequestMarshaller
implements Marshaller<Request<UpdateRepositoryDescriptionRequest>, UpdateRepositoryDescriptionRequest> {
    @Override
    public Request<UpdateRepositoryDescriptionRequest> marshall(UpdateRepositoryDescriptionRequest updateRepositoryDescriptionRequest) {
        if (updateRepositoryDescriptionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateRepositoryDescriptionRequest> request = new DefaultRequest<UpdateRepositoryDescriptionRequest>(updateRepositoryDescriptionRequest, "AWSCodeCommit");
        request.addHeader("X-Amz-Target", "CodeCommit_20150413.UpdateRepositoryDescription");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (updateRepositoryDescriptionRequest.getRepositoryName() != null) {
                jsonWriter.key("repositoryName").value(updateRepositoryDescriptionRequest.getRepositoryName());
            }
            if (updateRepositoryDescriptionRequest.getRepositoryDescription() != null) {
                jsonWriter.key("repositoryDescription").value(updateRepositoryDescriptionRequest.getRepositoryDescription());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

