/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateIdentityPoolRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String identityPoolName;
    private Boolean allowUnauthenticatedIdentities;
    private Map<String, String> supportedLoginProviders;
    private String developerProviderName;
    private List<String> openIdConnectProviderARNs;

    public void setIdentityPoolName(String identityPoolName) {
        this.identityPoolName = identityPoolName;
    }

    public String getIdentityPoolName() {
        return this.identityPoolName;
    }

    public CreateIdentityPoolRequest withIdentityPoolName(String identityPoolName) {
        this.setIdentityPoolName(identityPoolName);
        return this;
    }

    public void setAllowUnauthenticatedIdentities(Boolean allowUnauthenticatedIdentities) {
        this.allowUnauthenticatedIdentities = allowUnauthenticatedIdentities;
    }

    public Boolean getAllowUnauthenticatedIdentities() {
        return this.allowUnauthenticatedIdentities;
    }

    public CreateIdentityPoolRequest withAllowUnauthenticatedIdentities(Boolean allowUnauthenticatedIdentities) {
        this.setAllowUnauthenticatedIdentities(allowUnauthenticatedIdentities);
        return this;
    }

    public Boolean isAllowUnauthenticatedIdentities() {
        return this.allowUnauthenticatedIdentities;
    }

    public Map<String, String> getSupportedLoginProviders() {
        return this.supportedLoginProviders;
    }

    public void setSupportedLoginProviders(Map<String, String> supportedLoginProviders) {
        this.supportedLoginProviders = supportedLoginProviders;
    }

    public CreateIdentityPoolRequest withSupportedLoginProviders(Map<String, String> supportedLoginProviders) {
        this.setSupportedLoginProviders(supportedLoginProviders);
        return this;
    }

    public CreateIdentityPoolRequest addSupportedLoginProvidersEntry(String key, String value) {
        if (null == this.supportedLoginProviders) {
            this.supportedLoginProviders = new HashMap<String, String>();
        }
        if (this.supportedLoginProviders.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.supportedLoginProviders.put(key, value);
        return this;
    }

    public CreateIdentityPoolRequest clearSupportedLoginProvidersEntries() {
        this.supportedLoginProviders = null;
        return this;
    }

    public void setDeveloperProviderName(String developerProviderName) {
        this.developerProviderName = developerProviderName;
    }

    public String getDeveloperProviderName() {
        return this.developerProviderName;
    }

    public CreateIdentityPoolRequest withDeveloperProviderName(String developerProviderName) {
        this.setDeveloperProviderName(developerProviderName);
        return this;
    }

    public List<String> getOpenIdConnectProviderARNs() {
        return this.openIdConnectProviderARNs;
    }

    public void setOpenIdConnectProviderARNs(Collection<String> openIdConnectProviderARNs) {
        if (openIdConnectProviderARNs == null) {
            this.openIdConnectProviderARNs = null;
            return;
        }
        this.openIdConnectProviderARNs = new ArrayList<String>(openIdConnectProviderARNs);
    }

    public CreateIdentityPoolRequest withOpenIdConnectProviderARNs(String ... openIdConnectProviderARNs) {
        if (this.openIdConnectProviderARNs == null) {
            this.setOpenIdConnectProviderARNs(new ArrayList<String>(openIdConnectProviderARNs.length));
        }
        for (String ele : openIdConnectProviderARNs) {
            this.openIdConnectProviderARNs.add(ele);
        }
        return this;
    }

    public CreateIdentityPoolRequest withOpenIdConnectProviderARNs(Collection<String> openIdConnectProviderARNs) {
        this.setOpenIdConnectProviderARNs(openIdConnectProviderARNs);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIdentityPoolName() != null) {
            sb.append("IdentityPoolName: " + this.getIdentityPoolName() + ",");
        }
        if (this.getAllowUnauthenticatedIdentities() != null) {
            sb.append("AllowUnauthenticatedIdentities: " + this.getAllowUnauthenticatedIdentities() + ",");
        }
        if (this.getSupportedLoginProviders() != null) {
            sb.append("SupportedLoginProviders: " + this.getSupportedLoginProviders() + ",");
        }
        if (this.getDeveloperProviderName() != null) {
            sb.append("DeveloperProviderName: " + this.getDeveloperProviderName() + ",");
        }
        if (this.getOpenIdConnectProviderARNs() != null) {
            sb.append("OpenIdConnectProviderARNs: " + this.getOpenIdConnectProviderARNs());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIdentityPoolRequest)) {
            return false;
        }
        CreateIdentityPoolRequest other = (CreateIdentityPoolRequest)obj;
        if (other.getIdentityPoolName() == null ^ this.getIdentityPoolName() == null) {
            return false;
        }
        if (other.getIdentityPoolName() != null && !other.getIdentityPoolName().equals(this.getIdentityPoolName())) {
            return false;
        }
        if (other.getAllowUnauthenticatedIdentities() == null ^ this.getAllowUnauthenticatedIdentities() == null) {
            return false;
        }
        if (other.getAllowUnauthenticatedIdentities() != null && !other.getAllowUnauthenticatedIdentities().equals(this.getAllowUnauthenticatedIdentities())) {
            return false;
        }
        if (other.getSupportedLoginProviders() == null ^ this.getSupportedLoginProviders() == null) {
            return false;
        }
        if (other.getSupportedLoginProviders() != null && !other.getSupportedLoginProviders().equals(this.getSupportedLoginProviders())) {
            return false;
        }
        if (other.getDeveloperProviderName() == null ^ this.getDeveloperProviderName() == null) {
            return false;
        }
        if (other.getDeveloperProviderName() != null && !other.getDeveloperProviderName().equals(this.getDeveloperProviderName())) {
            return false;
        }
        if (other.getOpenIdConnectProviderARNs() == null ^ this.getOpenIdConnectProviderARNs() == null) {
            return false;
        }
        return other.getOpenIdConnectProviderARNs() == null || other.getOpenIdConnectProviderARNs().equals(this.getOpenIdConnectProviderARNs());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIdentityPoolName() == null ? 0 : this.getIdentityPoolName().hashCode());
        hashCode = 31 * hashCode + (this.getAllowUnauthenticatedIdentities() == null ? 0 : this.getAllowUnauthenticatedIdentities().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedLoginProviders() == null ? 0 : this.getSupportedLoginProviders().hashCode());
        hashCode = 31 * hashCode + (this.getDeveloperProviderName() == null ? 0 : this.getDeveloperProviderName().hashCode());
        hashCode = 31 * hashCode + (this.getOpenIdConnectProviderARNs() == null ? 0 : this.getOpenIdConnectProviderARNs().hashCode());
        return hashCode;
    }

    @Override
    public CreateIdentityPoolRequest clone() {
        return (CreateIdentityPoolRequest)super.clone();
    }
}

