/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ecs.model.StopTaskRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class StopTaskRequestMarshaller
implements Marshaller<Request<StopTaskRequest>, StopTaskRequest> {
    @Override
    public Request<StopTaskRequest> marshall(StopTaskRequest stopTaskRequest) {
        if (stopTaskRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<StopTaskRequest> request = new DefaultRequest<StopTaskRequest>(stopTaskRequest, "AmazonECS");
        String target = "AmazonEC2ContainerServiceV20141113.StopTask";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (stopTaskRequest.getCluster() != null) {
                jsonWriter.key("cluster").value(stopTaskRequest.getCluster());
            }
            if (stopTaskRequest.getTask() != null) {
                jsonWriter.key("task").value(stopTaskRequest.getTask());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

