/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.opsworks.model.CreateUserProfileRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class CreateUserProfileRequestMarshaller
implements Marshaller<Request<CreateUserProfileRequest>, CreateUserProfileRequest> {
    @Override
    public Request<CreateUserProfileRequest> marshall(CreateUserProfileRequest createUserProfileRequest) {
        if (createUserProfileRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateUserProfileRequest> request = new DefaultRequest<CreateUserProfileRequest>(createUserProfileRequest, "AWSOpsWorks");
        String target = "OpsWorks_20130218.CreateUserProfile";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createUserProfileRequest.getIamUserArn() != null) {
                jsonWriter.key("IamUserArn").value(createUserProfileRequest.getIamUserArn());
            }
            if (createUserProfileRequest.getSshUsername() != null) {
                jsonWriter.key("SshUsername").value(createUserProfileRequest.getSshUsername());
            }
            if (createUserProfileRequest.getSshPublicKey() != null) {
                jsonWriter.key("SshPublicKey").value(createUserProfileRequest.getSshPublicKey());
            }
            if (createUserProfileRequest.isAllowSelfManagement() != null) {
                jsonWriter.key("AllowSelfManagement").value(createUserProfileRequest.isAllowSelfManagement());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

