/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway;

import com.amazonaws.AmazonClientException;
import com.amazonaws.regions.Region;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;

public class StorageGatewayUtils {
    public static String getActivationKey(String gatewayAddress) throws AmazonClientException {
        return StorageGatewayUtils.getActivationKey(gatewayAddress, (String)null);
    }

    public static String getActivationKey(String gatewayAddress, Region activationRegion) throws AmazonClientException {
        return StorageGatewayUtils.getActivationKey(gatewayAddress, activationRegion == null ? null : activationRegion.getName());
    }

    public static String getActivationKey(String gatewayAddress, String activationRegionName) throws AmazonClientException {
        try {
            HttpGet method;
            CloseableHttpResponse response;
            int statusCode;
            BasicHttpParams httpClientParams = new BasicHttpParams();
            httpClientParams.setBooleanParameter("http.protocol.handle-redirects", false);
            DefaultHttpClient client = new DefaultHttpClient(httpClientParams);
            String url = "http://" + gatewayAddress;
            if (activationRegionName != null) {
                url = url + "/?activationRegion=" + activationRegionName;
            }
            if ((statusCode = (response = client.execute(method = new HttpGet(url))).getStatusLine().getStatusCode()) != 302) {
                throw new AmazonClientException("Could not fetch activation key.  HTTP status code: " + statusCode);
            }
            Header[] headers = response.getHeaders("Location");
            if (headers.length < 1) {
                throw new AmazonClientException("Could not fetch activation key, no location header found");
            }
            String activationUrl = headers[0].getValue();
            String[] parts = activationUrl.split("activationKey=");
            if (parts.length < 2 || null == parts[1]) {
                throw new AmazonClientException("Unable to get activation key from : " + activationUrl);
            }
            return parts[1];
        }
        catch (IOException ioe) {
            throw new AmazonClientException("Unable to get activation key", ioe);
        }
    }
}

