/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.sync.endpoint;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class MonitoredFileInputStream
extends FileInputStream {
    long bytesRead = 0L;

    public MonitoredFileInputStream(File file) throws FileNotFoundException {
        super(file);
    }

    @Override
    public int read() throws IOException {
        int value = super.read();
        if (value > -1) {
            ++this.bytesRead;
        }
        return value;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.updateBytesRead(super.read(b));
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.updateBytesRead(super.read(b, off, len));
    }

    public int updateBytesRead(int byteCount) {
        if (byteCount > 0) {
            this.bytesRead += (long)byteCount;
        }
        return byteCount;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }
}

