/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.syncoptimize.data;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDataHandler {
    private final Logger log = LoggerFactory.getLogger(TestDataHandler.class);

    public void createDirectories(File ... dirs) throws IOException {
        for (File dir : dirs) {
            if (dir.exists()) {
                try {
                    FileUtils.cleanDirectory((File)dir);
                }
                catch (IOException e) {
                    this.log.warn("Unable to clean directory {} due to  {}", (Object)dir.getAbsolutePath(), (Object)e.getMessage());
                }
                continue;
            }
            FileUtils.forceMkdir((File)dir);
        }
    }

    public void removeDirectories(File ... dirs) throws IOException {
        for (File dir : dirs) {
            try {
                FileUtils.deleteDirectory((File)dir);
            }
            catch (IOException e) {
                try {
                    FileUtils.cleanDirectory((File)dir);
                }
                catch (IOException e2) {
                    this.log.warn("Unable to clean directory {} due to  {}", (Object)dir.getAbsolutePath(), (Object)e2.getMessage());
                }
            }
        }
    }

    public void createTestData(File dataDir, int numFiles, int xMB) throws IOException {
        File file = new File(dataDir, "test-file.txt");
        FileWriter writer = new FileWriter(file);
        StringBuilder textBuilder = new StringBuilder();
        int x = 0;
        while ((long)x < 1024L) {
            textBuilder.append("x");
            ++x;
        }
        String text = textBuilder.toString();
        int y = 0;
        while ((long)y < 1024L * (long)xMB) {
            writer.write(text);
            ++y;
        }
        IOUtils.closeQuietly((Writer)writer);
        for (int z = 1; z < numFiles; ++z) {
            String filename = "test-file-" + z + ".txt";
            FileUtils.copyFile((File)file, (File)new File(dataDir, filename));
        }
    }
}

